/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_call_graph_printer_dot.h"
#include "ccc_call_graph.h"
#include "ccc_call_graph_node.h"
#include "ccc_call_graph_edge.h"
#include "ccc_settings.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Construction
// ----------------------------------------------------------------------------
CCC_CallGraphPrinterDot::CCC_CallGraphPrinterDot(std::string szFileName) :
	CCC_CallGraphPrinter(szFileName)
{
}


// ----------------------------------------------------------------------------
// Printing
// ----------------------------------------------------------------------------
void CCC_CallGraphPrinterDot::PrintGraph()
{
	m_os << "digraph G" << std::endl;
 	m_os << "{" << std::endl;

	// Print graph edges.
	std::vector<GraphEdge*>::iterator itGraphEdge = m_pCallGraph->m_edges.begin();
	while(itGraphEdge != m_pCallGraph->m_edges.end())
	{
		GraphNode* pSourceNode      = (*itGraphEdge)->GetSourceNode();
		GraphNode* pDestinationNode = (*itGraphEdge)->GetDestinationNode();

		m_os << "    \"" << pSourceNode->GetId()      << " - " << pSourceNode->GetName()      << "\""
		     << " -> \"" << pDestinationNode->GetId() << " - " << pDestinationNode->GetName() << "\";" << std::endl;

		itGraphEdge++;
	}

	m_os << "}" << std::endl;
}
