/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_CALL_GRAPH_PRINTER_SQL_H
#define CCC_CALL_GRAPH_PRINTER_SQL_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_call_graph_printer.h"


// ----------------------------------------------------------------------------
// Class declarations
// ----------------------------------------------------------------------------
class sqlite3;
class sqlite3_stmt;
class GraphEdge;
class GraphNode;


// ----------------------------------------------------------------------------
// Class CCC_CallGraphPrinterSql
// ----------------------------------------------------------------------------
class CCC_CallGraphPrinterSql : public CCC_CallGraphPrinter
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	CCC_CallGraphPrinterSql(std::string szFileName);


	// ------------------------------------------------------------------------
	// Printing
	// ------------------------------------------------------------------------
protected:
	virtual void PrintGraph();
	
	
	// ------------------------------------------------------------------------
	// Querying primitives
	// ------------------------------------------------------------------------
private:
	bool Open();
	bool Close();
	bool Query(std::string szQuery);
	bool BindAndQuery(sqlite3_stmt* ppq, int i1);
	bool BindAndQuery(sqlite3_stmt* ppq, int i1, int i2, int i3);
	bool BindAndQuery(sqlite3_stmt* ppq, int i1, std::string sz2);
	bool QueryFromStatement(sqlite3_stmt* ppq);
	
	bool Prepare(sqlite3_stmt** pppq, std::string szQuery);


	// ------------------------------------------------------------------------
	// Queries
	// ------------------------------------------------------------------------
private:
	bool ApplySettings();
	bool ClearTables();
	bool CreateTables();
	bool CreateIndices();
	bool PrepareQueries();
	void DestroyQueries();

	bool CreateEdges();
	bool AnnotateEdges();
	bool AnnotateEdge(GraphEdge* pGraphEdge);
	bool AnnotateNodes();
	bool AnnotateNode(GraphNode* pGraphNode);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	sqlite3*    m_pSqlite;
	std::string m_szQuery;


	// ------------------------------------------------------------------------
	// Prepared insertion queries
	// ------------------------------------------------------------------------
private:
	// Edge insertion queries.	
	sqlite3_stmt* ppqInsertEdge;

	// Edge attribute insertion queries.
	sqlite3_stmt* ppqInsertEdgeAttrTypeInclusion;
	sqlite3_stmt* ppqInsertEdgeAttrTypeCall;

	sqlite3_stmt* ppqInsertEdgeAttrCallFile;
	sqlite3_stmt* ppqInsertEdgeAttrCallPosition;
	sqlite3_stmt* ppqInsertEdgeAttrCallIsVirtual;
	sqlite3_stmt* ppqInsertEdgeAttrCallIsAccurate;
	sqlite3_stmt* ppqInsertEdgeAttrCallCandidateSetId;
	sqlite3_stmt* ppqInsertEdgeAttrCallViaPointerNo;
	sqlite3_stmt* ppqInsertEdgeAttrCallViaPointerPointerToFunction;
	sqlite3_stmt* ppqInsertEdgeAttrCallViaPointerPointerToMember;
	sqlite3_stmt* ppqInsertEdgeAttrCallOnObjectNo;
	sqlite3_stmt* ppqInsertEdgeAttrCallOnObjectObjectInstance;
	sqlite3_stmt* ppqInsertEdgeAttrCallOnObjectObjectReference;
	sqlite3_stmt* ppqInsertEdgeAttrCallOnObjectObjectPointer;

	// Node attribute insertion queries.
	sqlite3_stmt* ppqInsertNodeAttrName;
	sqlite3_stmt* ppqInsertNodeAttrTypeDirectory;
	sqlite3_stmt* ppqInsertNodeAttrTypeFile;
	sqlite3_stmt* ppqInsertNodeAttrTypeClass;
	sqlite3_stmt* ppqInsertNodeAttrTypeFunction;

	sqlite3_stmt* ppqInsertNodeAttrSignature;
	sqlite3_stmt* ppqInsertNodeAttrClass;
	sqlite3_stmt* ppqInsertNodeAttrIsMethod;
	sqlite3_stmt* ppqInsertNodeAttrIsVirtual;
	sqlite3_stmt* ppqInsertNodeAttrIsStatic;
	sqlite3_stmt* ppqInsertNodeAttrIsStaticLinkage;
	sqlite3_stmt* ppqInsertNodeAttrIsInline;
	sqlite3_stmt* ppqInsertNodeAttrDeclarationFile;
	sqlite3_stmt* ppqInsertNodeAttrDeclarationPosition;
	sqlite3_stmt* ppqInsertNodeAttrDefinitionFile;
	sqlite3_stmt* ppqInsertNodeAttrDefinitionPosition;
	sqlite3_stmt* ppqInsertNodeAttrAccessSpecifierPublic;
	sqlite3_stmt* ppqInsertNodeAttrAccessSpecifierProtected;
	sqlite3_stmt* ppqInsertNodeAttrAccessSpecifierPrivate;
};


#endif
