/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_CALL_GRAPH_PRINTER_TLP_H
#define CCC_CALL_GRAPH_PRINTER_TLP_H


// ----------------------------------------------------------------------------
// Graph annotation specification
// ==============================
//
// Graph Nodes
// ===========
//
// Graph nodes have the following properties.
//
// Property: type
// --------------
// The type property will be one of the following.
// * RootFunction : This is a fictional node. It has no representation in the
//                  original source code. Each graph has exactly one of these
//                  nodes. It exists to emulate the 'Function' that calls the
//                  program's initializers, the program's main function and
//                  finally the program's finalizers.
// * Function     : Represents a function from the original source code.
// * File         : Represents a source code file that contains one or more
//                  functions currently present in the graph. Every
//                  FunctionNode is contained by exactly one FileNode. A
//                  FileNode will always have one or more ContainsEdges to
//                  the FileNodes it contains.
// * Class        : Represents a class from the source code. Like the
//                  FileNode, a ClassNode contains FunctionNodes currently
//                  present in the graph. Obviously, these methods are
//                  members of the class the node represents.
//
// Property: viewLabel
// -------------------
// The viewLabel property will contain a display name that is relevant for the
// particular node. The following values are used for the different types of
// nodes.
// * RootFunction : viewLabel is set to 'Root'.
// * Function     : viewLabel is set to the unqualified name of the function
//                  that the node represents.
// * File         : viewLabel is set to the relative directory plus the file
//                  name of the file that the node represents.
// * Class        : viewLabel is set to the unqualified name of the class that
//                  the node represents. That is, any namespaces or parent
//                  classes are not included.
//
// Property: signature
// -------------------
// The signature property is set for Function and File nodes. For other types of
// nodes, it is empty.
// Function       : Contains the fully qualified name of the function that the
//                  node represents.
// Class          : Contains the fully qualified name of the class that the node
//                  represents. That is, it includes any namespaces and parent
//                  classes.
//
//
// Graph Edges
// ===========
//
// Edges are of one of the following types:
// * CallsEdge       : This edge represents a function call. The source node is
//                     the caller, the destination node is the callee.
// * ContainsEdge    : This edge indicates that the destination node is
//                     hierarchically contained within the source node.
//
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_call_graph_printer.h"


// ----------------------------------------------------------------------------
// Class CCC_CallGraphPrinterTlp
// ----------------------------------------------------------------------------
class CCC_CallGraphPrinterTlp : public CCC_CallGraphPrinter
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	CCC_CallGraphPrinterTlp(std::string szFileName);


	// ------------------------------------------------------------------------
	// Printing
	// ------------------------------------------------------------------------
protected:
	virtual void PrintGraph();

private:
	// Printing nodes and edges.
	void PrintNodes();
	void PrintEdges();

	// Printing generic properties.
	void PrintPropertyType();

	// Printing node properties.
	void PrintNodePropertyViewLabel();
	void PrintNodePropertySignature();
	void PrintNodePropertyClassName();
	void PrintNodePropertyIsMethod();
	void PrintNodePropertyIsVirtual();
	void PrintNodePropertyIsStatic();
	void PrintNodePropertyIsStaticLinkage();
	void PrintNodePropertyIsInline();
	void PrintNodePropertyDeclarationFile();
	void PrintNodePropertyDeclarationPosition();
	void PrintNodePropertyDefinitionFile();
	void PrintNodePropertyDefinitionPosition();
	void PrintNodePropertyAccessSpecifier();

	// Printing edge properties.
	void PrintEdgePropertyCallFile();
	void PrintEdgePropertyCallPosition();
	void PrintEdgePropertyCallIsVirtual();
	void PrintEdgePropertyCallIsAccurate();
	void PrintEdgePropertyCallCandidateSetId();
	void PrintEdgePropertyCallViaPointer();
	void PrintEdgePropertyCallOnObject();
};


#endif
