/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_full_call_graph.h"
#include "ccc_global_function_repository.h"
#include "ccc_settings.h"
#include "ccc_verbose_print.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Graph calculation
// ----------------------------------------------------------------------------
void CCC_FullCallGraph::InsertNodes()
{
	// Process all global functions.
	GlobalFunctionMap* pGlobalFunctions = m_pGlobalFunctionRepository->GetGlobalFunctions();
	GlobalFunctionMap::iterator itGlobalFunction = pGlobalFunctions->begin();
	while(itGlobalFunction != pGlobalFunctions->end())
	{
		CCC_GlobalFunction* pGlobalFunction = itGlobalFunction->second;

		// Get the CCC_GlobalFunction associated with the signature and then
		// iterate over all its local functions.
		LocalFunctionVector localFunctions;
		GetPreferredLocalFunctions(pGlobalFunction, localFunctions);
		LocalFunctionVector::iterator itLocalFunction = localFunctions.begin();
		while(itLocalFunction != localFunctions.end())
		{
			CCI_LocalFunction* pLocalFunction = *itLocalFunction;

			InsertFunctionGraphNode(pLocalFunction);

			// Advance to the next local function.
			itLocalFunction++;
		}

		// Advance to the next global function.
		itGlobalFunction++;
	}
}

CCC_GlobalFunction* CCC_FullCallGraph::GetMainEntryPoint()
{
	std::string szSignature;
	CCC_GlobalFunction* pGlobalFunction = NULL;
	FindMainFunction(szSignature, pGlobalFunction);
	return pGlobalFunction;
}
