/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 
// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_global_function.h"
#include <algorithm>
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Construction
// ----------------------------------------------------------------------------
CCC_GlobalFunction::CCC_GlobalFunction()
{
	//m_signature = "";
	//m_callSignature = "";
}


// ----------------------------------------------------------------------------
// Properties
// ----------------------------------------------------------------------------
std::string CCC_GlobalFunction::GetSignature()
{
	if(m_localFunctions.size() == 0)
		return "";
	else
		return m_localFunctions[0]->GetSignature();
	
	//return m_signature;
}

std::string CCC_GlobalFunction::GetPointerSignature()
{
	if(m_localFunctions.size() == 0)
		return "";
	else
		return m_localFunctions[0]->GetPointerSignature();

	//return m_callSignature;
}

LocalFunctionVector* CCC_GlobalFunction::GetLocalFunctions()
{
	return &m_localFunctions;
}

StringVector* CCC_GlobalFunction::GetOverridingMethods()
{
	return &m_overridingMethods;
}

void CCC_GlobalFunction::AddOverridingMethod(std::string signature)
{
	// If the supplied signature has not been added to this CCC_GlobalFunction,
	// then add it now.
	if(find(m_overridingMethods.begin(), m_overridingMethods.end(), signature) == m_overridingMethods.end())
		m_overridingMethods.push_back(signature);
}


// ----------------------------------------------------------------------------
// TranslationUnitFunction management
// ----------------------------------------------------------------------------
void CCC_GlobalFunction::AddLocalFunction(CCI_LocalFunction* pLocalFunction)
{
	// Set this CCC_GlobalFunction's signature.
	//if(m_signature == "")
	//{
	//	m_signature     = pLocalFunction->GetSignature();
	//	m_callSignature = pLocalFunction->GetPointerSignature();
	//}
	//else
	if(m_localFunctions.size() > 0)
	{
		cci_assert_msg(GetSignature()        == pLocalFunction->GetSignature()       , "The signature of the supplied CCI_LocalFunction does not match the signature of the CCC_GlobalFunction to which it is to be added.");
		cci_assert_msg(GetPointerSignature() == pLocalFunction->GetPointerSignature(), "The pointer signature of the supplied CCI_LocalFunction does not match the pointer signature of the CCC_GlobalFunction to which it is to be added.");
	}

	// If this CCC_GlobalFunction does not yet contain a CCI_LocalFunction that is
	// equal to pLocalFunction, then add pLocalFunction to this CCC_GlobalFunction.
	CCI_LocalFunction* pExistingLocalFunction = FindExistingLocalFunction(pLocalFunction);
	if(pExistingLocalFunction == NULL)
	{
		// There is no CCI_LocalFunction in this CCC_GlobalFunction yet that is
		// equal to ptuFunction.
		m_localFunctions.push_back(pLocalFunction);
	}
}

/*
bool CCC_GlobalFunction::ContainsLocalFunction(CCI_LocalFunction* pLocalFunction)
{
	LocalFunctionVector::iterator it = m_localFunctions.begin();
	while(it != m_localFunctions.end())
	{
		if(**it == *pLocalFunction)
			return true;
		it++;
	}

	return false;
}
*/

CCI_LocalFunction* CCC_GlobalFunction::FindExistingLocalFunction(CCI_LocalFunction* pLocalFunction)
{
	LocalFunctionVector::iterator it = m_localFunctions.begin();
	while(it != m_localFunctions.end())
	{
		if(**it == *pLocalFunction)
			return *it;

		it++;
	}

	return NULL;
}


// ----------------------------------------------------------------------------
// Debugging
// ----------------------------------------------------------------------------
void CCC_GlobalFunction::Print(std::string prefix)
{
	std::cout << std::endl << prefix << "Global function";
	std::cout << std::endl << prefix << "{";

	std::cout << std::endl << prefix << "\tSignature        : " << GetSignature();
	std::cout << std::endl << prefix << "\tPointer signature: " << GetPointerSignature();
	std::cout << std::endl;

	// Print the CCI_LocalFunction of this CCC_GlobalFunction.
	LocalFunctionVector::iterator itLocalFunction = m_localFunctions.begin();
	while(itLocalFunction != m_localFunctions.end())
	{
		if(itLocalFunction != m_localFunctions.begin())
			std::cout << std::endl;

		(*itLocalFunction)->PrintOut(prefix + "\t");
		itLocalFunction++;
	}

	// Print the signatures of the methods that override this method.
	if(m_overridingMethods.size() > 0)
	{
		std::cout << std::endl;
		std::cout << std::endl << prefix << "\tOverriden by";
		std::cout << std::endl << prefix << "\t{";

		StringVector::iterator itOverridingMethod = m_overridingMethods.begin();
		while(itOverridingMethod != m_overridingMethods.end())
		{
			std::cout << std::endl << prefix << "\t\t" << *itOverridingMethod;
			itOverridingMethod++;
		}

		std::cout << std::endl << prefix << "\t}";
	}

	std::cout << std::endl << prefix << "}";
}
