/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_GLOBAL_FUNCTION_H
#define CCC_GLOBAL_FUNCTION_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Class CCC_GlobalFunction
// ----------------------------------------------------------------------------
class CCC_GlobalFunction
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	CCC_GlobalFunction();


	// ------------------------------------------------------------------------
	// Properties
	// ------------------------------------------------------------------------
public:
	std::string GetSignature();
	std::string GetPointerSignature();
	LocalFunctionVector* GetLocalFunctions();


	// ------------------------------------------------------------------------
	// Management of methods that override this method
	// ------------------------------------------------------------------------
public:
	StringVector* GetOverridingMethods();
	void AddOverridingMethod(std::string signature);


	// ------------------------------------------------------------------------
	// TranslationUnitFunction management
	// ------------------------------------------------------------------------
public:
	void AddLocalFunction(CCI_LocalFunction* pLocalFunction);

private:
	CCI_LocalFunction* FindExistingLocalFunction(CCI_LocalFunction* pLocalFunction);


	// ------------------------------------------------------------------------
	// Debugging
	// ------------------------------------------------------------------------
public:
	void Print(std::string prefix);
	

	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	LocalFunctionVector m_localFunctions;

	StringVector m_overridingMethods;
};


#endif
