/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_GLOBAL_FUNCTION_REPOSITORY_H
#define CCC_GLOBAL_FUNCTION_REPOSITORY_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_global_function.h"
#include "ccc_typedefs.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Class CCC_GlobalFunctionRepository
// ----------------------------------------------------------------------------
class CCC_GlobalFunctionRepository
{
	// ------------------------------------------------------------------------
	// Construction & destruction
	// ------------------------------------------------------------------------
public:
	void Finalize();


	// ------------------------------------------------------------------------
	// Repository management
	// ------------------------------------------------------------------------
public:
	bool ContainsGlobalFunctionWithSignature(std::string signature);
	bool ContainsGlobalFunctionWithPointerSignature(std::string szPointerSignature);

	CCC_GlobalFunction* GetGlobalFunction(std::string signature);
	GlobalFunctionMap* GetGlobalFunctions();
	GlobalFunctionVector* GetGlobalFunctionVector(std::string szPointerSignature);
	GlobalFunctionVectorMap* GetGlobalFunctionVectors();

	void AddLocalFunction(CCI_LocalFunction* ptuFunction);
	void AddLocalFunctionMap(LocalFunctionMap* pLocalFunctions);


	// ------------------------------------------------------------------------
	// Debugging
	// ------------------------------------------------------------------------
public:
	void Print(std::string prefix);
	void PrintSignatureMapping(std::string prefix);
	void PrintCallSignatureMapping(std::string prefix);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	GlobalFunctionMap       m_signatureToGlobalFunction;
	GlobalFunctionVectorMap m_pointerSignatureToGlobalFunctionVector;
};


#endif
