/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_PARTIAL_CALL_GRAPH_H
#define CCC_PARTIAL_CALL_GRAPH_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_call_graph.h"


// ----------------------------------------------------------------------------
// Class 
// ----------------------------------------------------------------------------
class CCC_PartialCallGraph : public CCC_CallGraph
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	CCC_PartialCallGraph(std::string szEntryPoint);


	// ------------------------------------------------------------------------
	// Graph calculation
	// ------------------------------------------------------------------------
protected:
	virtual void InsertNodes();
	virtual CCC_GlobalFunction* GetMainEntryPoint();

private:
	void InsertNode(CCC_GlobalFunction* pGlobalFunction);
	void InsertNode(CCI_LocalFunction* pLocalFunction);
	
	void InsertNodesForInitializingFunctionCalls();
	void InsertNodesForFinalizingFunctionCalls();


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	std::string m_szEntryPoint;
};


#endif
