/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCC_CONSTRUCTOR_SETTINGS_H
#define CCC_CONSTRUCTOR_SETTINGS_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccc_typedefs.h"
#include <string>


// ----------------------------------------------------------------------------
// Enums
// ----------------------------------------------------------------------------
enum CCC_Action
{
	CCC_A_PrintVersion,
	CCC_A_PrintUsage,
	CCC_A_PrintSignatures,
	CCC_A_ConstructCallGraph
};

enum CCC_InputType
{
	CCC_IT_Binary,
 	CCC_IT_Xml
};

enum CCC_OutputFormat
{
	CCC_OF_Dot,
	CCC_OF_Tulip,
	CCC_OF_Sqlite
};


// ----------------------------------------------------------------------------
// Class CCC_ConstructorSettings
// ----------------------------------------------------------------------------
class CCC_ConstructorSettings
{
	// ------------------------------------------------------------------------
	// Parsing
	// ------------------------------------------------------------------------
public:
	static bool Parse(int argc, char** argv);

private:
	static bool IsSwitch(char* pszSwitch, const char* pszShortArgument, const char* pszLongArgument);
	static bool StartsWith(char* pszSwitch, const char* pszStartsWith);
	static bool CheckArgument(char* pszSwitch, char* pszArgument, const char* pszExpected);


	// ------------------------------------------------------------------------
	// Settings
	// ------------------------------------------------------------------------
public:
	static StringVector* GetInputFileNames();

	static void SetInputType(CCC_InputType inputType);
	static CCC_InputType GetInputType();

	static void SetEntryPointName(std::string entryPointName);
	static std::string GetEntryPointName();

	static void SetOutputFormat(CCC_OutputFormat outputFormat);
	static CCC_OutputFormat GetOutputFormat();

	static void SetOutputFileName(std::string szOutputFileName);
	static std::string GetOutputFileName();
	
	static void SetValidateInput(bool bValidateInput);
	static bool GetValidateInput();
	
	static void SetConservativenessWarningsListCandidates(bool bConservativenessWarningsListCandidates);
	static bool GetConservativenessWarningsListCandidates();

	static void SetConservativenessDisableWarningsOneCandidate(bool bConservativenessDisableWarningsOneCandidate);
	static bool GetConservativenessDisableWarningsOneCandidate();

	static void SetConservativenessDisableWarnings(bool bConservativenessDisableWarnings);
	static bool GetConservativenessDisableWarnings();
	
	static void SetIncludeInitFinit(bool bIncludeInitFinit);
	static bool GetIncludeInitFinit();

	static void SetVerbose(bool bVerbose);
	static bool GetVerbose();

	static void SetAction(CCC_Action action);
	static CCC_Action GetAction();

	static std::string GetProgramName();


	// ------------------------------------------------------------------------
	// Debugging
	// ------------------------------------------------------------------------
public:
	static void Print(std::string prefix);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	static StringVector     m_inputFileNames;
	static CCC_InputType    m_inputType;
	static std::string      m_entryPointName;
	static CCC_OutputFormat m_outputFormat;
	static std::string      m_szOutputFileName;
	static bool             m_bValidateInput;
	static bool             m_bConservativenessWarningsListCandidates;
	static bool             m_bConservativenessDisableWarningsOneCandidate;
	static bool             m_bConservativenessDisableWarnings;
	static bool             m_bIncludeInitFinit;
	static bool             m_bVerbose;
	static CCC_Action       m_action;
	static std::string      m_programName;
};


#endif
