/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_ASSERT_H
#define CCI_ASSERT_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include <iostream>
#include <stdlib.h>


// -----------------------------------------------------------------------------
// Defines
// -----------------------------------------------------------------------------

// Tests 'expr'. If the result is false, a message containing the assertion, the
// file, function and line number where the assertion failed is printed to
// stderr.
#define cci_assert_allow(expr)													\
{																				\
	if(!(expr))																	\
	{																			\
		std::cerr << "ASSERTION FAILED"                     << std::endl;		\
		std::cerr << "{"                                    << std::endl;		\
		std::cerr << "\tAssertion: " << #expr               << std::endl;		\
		std::cerr << "\tFile     : " << __FILE__            << std::endl;		\
		std::cerr << "\tFunction : " << __PRETTY_FUNCTION__ << std::endl;		\
		std::cerr << "\tLine     : " << __LINE__            << std::endl;		\
		std::cerr << "}"                                    << std::endl;		\
		fflush(stderr);															\
	}																			\
}

// Like 'assert_allow', but terminates after printing.
#define cci_assert(expr)														\
{																				\
	if(!(expr))																	\
	{																			\
		cci_assert_allow(expr);													\
		exit(1);																\
	}																			\
}

// Tests 'expr'. If the result is false, a message containing the assertion, the
// file, function and line number where the assertion failed and the supplied
// 'msg' is printed to stderr.
#define cci_assert_msg_allow(expr, msg)											\
{																				\
	if(!(expr))																	\
	{																			\
		std::cerr << "ASSERTION FAILED"                     << std::endl;		\
		std::cerr << "{"                                    << std::endl;		\
		std::cerr << "\tAssertion: " << #expr               << std::endl;		\
		std::cerr << "\tFile     : " << __FILE__            << std::endl;		\
		std::cerr << "\tFunction : " << __PRETTY_FUNCTION__ << std::endl;		\
		std::cerr << "\tLine     : " << __LINE__            << std::endl;		\
		std::cerr << "\tMessage  : " << msg                 << std::endl;		\
		std::cerr << "}"                                    << std::endl;		\
		fflush(stderr);															\
	}																			\
}

// Like 'assert_msg_allow', but terminates after printing.
#define cci_assert_msg(expr, msg)												\
{																				\
	if(!(expr))																	\
	{																			\
		cci_assert_msg_allow(expr, msg);										\
		exit(1);																\
	}																			\
}


#endif
