/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_DEFINES_H
#define CCI_DEFINES_H


// -----------------------------------------------------------------------------
// Generic macros
// -----------------------------------------------------------------------------

// If b is false, returns false. Otherwise, does nothing.
#define CCI_TRY(b)															   \
{																			   \
	if (!(b))																   \
	{																		   \
		return false;														   \
	}																		   \
}

// If ptr is not NULL, deletes ptr and sets it to NULL. Otherwise, does nothing.
#define CCI_DELETE(ptr)														   \
{																			   \
	if(ptr != NULL)															   \
	{																		   \
		delete ptr;															   \
		ptr = NULL;															   \
	}																		   \
}

// If b is false, deletes ptr and returns false. Otherwise, does nothing.
#define CCI_DELETE_ON_FAIL(b, ptr)											   \
{																			   \
	if(!(b))																   \
	{																		   \
		CCI_DELETE(ptr);													   \
		return false;														   \
	}																		   \
}

// If b is false, deletes ptr1 and ptr2 and returns false. Otherwise, does nothing.
#define CCI_DELETE_ON_FAIL2(b, ptr1, ptr2)									   \
{																			   \
	if(!(b))																   \
	{																		   \
		CCI_DELETE(ptr1);													   \
		CCI_DELETE(ptr2);													   \
		return false;														   \
	}																		   \
}

// Deletes all values in the map and then erases all elements from the map.
#define CCI_CLEANUP_MAP(map, mapType)										   \
{																			   \
	mapType::iterator it = map.begin();										   \
	while(it != map.end())													   \
	{																		   \
		delete it->second;													   \
		it++;																   \
	}																		   \
	map.clear();															   \
}

// Deletes all elements in the vectors and then erases all elements from the vector.
#define CCI_CLEANUP_VECTOR(vector, vectorType)								   \
{																			   \
	vectorType::iterator it = vector.begin();								   \
	while(it != vector.end())												   \
	{																		   \
		delete *it;															   \
		it++;																   \
	}																		   \
	vector.clear();															   \
}

// If b is false, cleans up the map and returns false. Otherwise, does nothing.
#define CCI_CLEANUP_MAP_ON_FAIL(b, map, mapType)							   \
{																			   \
	if(!(b))																   \
	{																		   \
		CCI_CLEANUP_MAP(map, mapType);										   \
		return false;														   \
	}																		   \
}

// If b is false, cleans up the vector, deletes ptr and returns false. Otherwise, does nothing.
#define CCI_CLEANUP_VECTOR_AND_DELETE_ON_FAIL(b, vector, vectorType, ptr)      \
{																			   \
	if(!(b))																   \
	{																		   \
		CCI_CLEANUP_VECTOR(vector, vectorType);								   \
		CCI_DELETE(ptr);													   \
		return false;														   \
	}																		   \
}


#endif
