/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_DESERIALIZER_H
#define CCI_DESERIALIZER_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_local_function.h"
#include "libcci/cci_function_declaration.h"
#include "libcci/cci_function_definition.h"
#include "libcci/cci_function_call.h"
#include "libcci/cci_sourceloc.h"
#include "libcci/cci_typedefs.h"
#include <fstream>


// -----------------------------------------------------------------------------
// Class CCI_Deserializer
// -----------------------------------------------------------------------------
class CCI_Deserializer
{
	// -------------------------------------------------------------------------
	// Construction & destruction
	// -------------------------------------------------------------------------
public:
	CCI_Deserializer();
	CCI_Deserializer(std::string szFileName);
	virtual ~CCI_Deserializer() { }


	// -------------------------------------------------------------------------
	// Output stream
	// -------------------------------------------------------------------------
protected:
	virtual std::ios::openmode GetStreamOpenMode();


	// -------------------------------------------------------------------------
	// Deserialization
	// -------------------------------------------------------------------------
public:
	bool Deserialize(LocalFunctionMap & localFunctions, FunctionCallVector & initializingCalls, FunctionCallVector & finalizingCalls);

protected:
	virtual bool ReadCallInfo(LocalFunctionMap & localFunctions, FunctionCallVector & initializingCalls, FunctionCallVector & finalizingCalls) = 0;

protected:
	bool ReadInt(int & iValue);
	bool ReadBool(bool & bValue);
	bool ReadString(std::string & szValue);
	bool Read(void* pValue, int iLength);
	bool Read(const void* pValue, int iLength);


	// -------------------------------------------------------------------------
	// Attributes
	// -------------------------------------------------------------------------
protected:
	std::istream & m_is;

private:
	std::string m_szFileName;
	std::ifstream m_ifs;
	bool m_bUseFileStream;
};


#endif
