/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_DESERIALIZER_XML_H
#define CCI_DESERIALIZER_XML_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_deserializer.h"


// -----------------------------------------------------------------------------
// Class CCI_DeserializerXml
// -----------------------------------------------------------------------------
class CCI_DeserializerXml : public CCI_Deserializer
{
	// -------------------------------------------------------------------------
	// Construction & destruction
	// -------------------------------------------------------------------------
public:
	CCI_DeserializerXml();
	CCI_DeserializerXml(std::string szFileName);


	// -------------------------------------------------------------------------
	// Output stream
	// -------------------------------------------------------------------------
protected:
	virtual std::ios::openmode GetStreamOpenMode();


	// -------------------------------------------------------------------------
	// Deserialization
	// -------------------------------------------------------------------------
protected:
	virtual bool ReadCallInfo(LocalFunctionMap & localFunctions, FunctionCallVector & initializingCalls, FunctionCallVector & finalizingCalls);
};


#endif
