/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef CCI_FUNCTION_DEFINITION_H
#define CCI_FUNCTION_DEFINITION_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_locatable.h"
#include "libcci/cci_typedefs.h"



// -----------------------------------------------------------------------------
// Class CCI_FunctionDefinition
// -----------------------------------------------------------------------------
class CCI_FunctionDefinition : public CCI_Locatable
{
	// -------------------------------------------------------------------------
	// Construction & destruction
	// -------------------------------------------------------------------------
public:
	// Constructs a CCI_FunctionDefinition with the specified properties.
	CCI_FunctionDefinition(CCI_SourceLoc* pSourceLoc, FunctionCallVector* pFunctionCalls);
	~CCI_FunctionDefinition();


	// -------------------------------------------------------------------------
	// Properties
	// -------------------------------------------------------------------------
public:
	// Returns a pointer to the vector that contains the function calls that are
	// made in this function definition.
	FunctionCallVector* GetFunctionCalls();


	// -------------------------------------------------------------------------
	// Equality
	// -------------------------------------------------------------------------
public:
	// Returns whether this function definition is equal to the other function
	// definition. Two function definition are considered equal iff their
	// CCI_Locatable bases are equal according to the == operator.
	bool operator== (CCI_FunctionDefinition & other);
	bool operator!= (CCI_FunctionDefinition & other);


	// -------------------------------------------------------------------------
	// Printable implementation
	// -------------------------------------------------------------------------
public:
	virtual std::string ToString(std::string szPrefix);


	// -------------------------------------------------------------------------
	// Attributes
	// -------------------------------------------------------------------------
private:
	// Contains all function calls that are made in this function definition.
	FunctionCallVector m_functionCalls;
};


#endif
