/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef CCI_LOCATABLE_H
#define CCI_LOCATABLE_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_printable.h"


// -----------------------------------------------------------------------------
// Class declarations
// -----------------------------------------------------------------------------
class CCI_SourceLoc;


// -----------------------------------------------------------------------------
// Class CCI_Locatable
// -----------------------------------------------------------------------------
class CCI_Locatable : public CCI_Printable
{
	// -------------------------------------------------------------------------
	// Construction & destruction
	// -------------------------------------------------------------------------
public:
	CCI_Locatable(CCI_SourceLoc* pSourceLoc);
	virtual ~CCI_Locatable();


	// -------------------------------------------------------------------------
	// Properties
	// -------------------------------------------------------------------------
public:
	CCI_SourceLoc* GetSourceLoc();


	// -------------------------------------------------------------------------
	// Equality
	// -------------------------------------------------------------------------
public:
	// Returns whether this CCI_Locatable is equal to the other CCI_Locatable.
	// Two CCI_Locatables are considered equal iff the dereferenced values of
	// their m_pSourceLocs are equal, according to their == operator.
	bool operator== (CCI_Locatable & other);
	bool operator!= (CCI_Locatable & other);


	// -------------------------------------------------------------------------
	// Printable implementation
	// -------------------------------------------------------------------------
public:
	virtual std::string ToString(std::string szPrefix);


	// -------------------------------------------------------------------------
	// Attributes
	// -------------------------------------------------------------------------
protected:
	CCI_SourceLoc* m_pSourceLoc;
};


#endif
