/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_SERIALIZER_H
#define CCI_SERIALIZER_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_local_function.h"
#include "libcci/cci_function_declaration.h"
#include "libcci/cci_function_definition.h"
#include "libcci/cci_function_call.h"
#include "libcci/cci_sourceloc.h"
#include "libcci/cci_typedefs.h"
#include <fstream>


// -----------------------------------------------------------------------------
// Class CCI_Serializer
// -----------------------------------------------------------------------------
class CCI_Serializer
{
	// -------------------------------------------------------------------------
	// Construction & destruction
	// -------------------------------------------------------------------------
public:
	CCI_Serializer();
	CCI_Serializer(std::string szFileName);
	virtual ~CCI_Serializer() { }


	// -------------------------------------------------------------------------
	// Output stream
	// -------------------------------------------------------------------------
protected:
	virtual std::ios::openmode GetStreamOpenMode();


	// -------------------------------------------------------------------------
	// Serialization
	// -------------------------------------------------------------------------
public:
	bool Serialize(LocalFunctionMap* pLocalFunctions, FunctionCallVector* pInitializingCalls, FunctionCallVector* pFinalizingCalls);
	
protected:
	virtual bool WriteCallInfo(LocalFunctionMap* pLocalFunctions, FunctionCallVector* pInitializingCalls, FunctionCallVector* pFinalizingCalls) = 0;

protected:
	bool WriteInt(int iValue);
	bool WriteBool(bool bValue);
	bool WriteString(std::string szValue);
	bool Write(void* pBuffer, int iLength);
	bool Write(const void* pBuffer, int iLength);


	// -------------------------------------------------------------------------
	// Attributes
	// -------------------------------------------------------------------------
protected:
	std::string m_szFileName;
	std::ostream & m_os;

private:
	std::ofstream m_ofs;
	bool m_bUseFileStream;
};


#endif
