/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_SERIALIZER_BIN_H
#define CCI_SERIALIZER_BIN_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_serializer.h"


// -----------------------------------------------------------------------------
// Class CCI_SerializerBin
// -----------------------------------------------------------------------------
class CCI_SerializerBin : public CCI_Serializer
{
	// -------------------------------------------------------------------------
	// Construction & destruction
	// -------------------------------------------------------------------------
public:
	CCI_SerializerBin();
	CCI_SerializerBin(std::string szFileName);


	// -------------------------------------------------------------------------
	// Output stream
	// -------------------------------------------------------------------------
protected:
	virtual std::ios::openmode GetStreamOpenMode();


	// -------------------------------------------------------------------------
	// Serialization
	// -------------------------------------------------------------------------
protected:
	virtual bool WriteCallInfo(LocalFunctionMap* pLocalFunctions, FunctionCallVector* pInitializingCalls, FunctionCallVector* pFinalizingCalls);

private:
	bool WriteLocalFunctions(LocalFunctionMap* pLocalFunctions);
	bool WriteInitializingCalls(FunctionCallVector* pInitializingCalls);
	bool WriteFinalizingCalls(FunctionCallVector* pFinalizingCalls);

	bool WriteLocalFunction(CCI_LocalFunction* pLocalFunction);
	bool WriteFunctionDeclaration(CCI_FunctionDeclaration* pFunctionDeclaration);
	bool WriteFunctionDefinition(CCI_FunctionDefinition* pFunctionDefinition);
	bool WriteFunctionCall(CCI_FunctionCall* pFunctionCall);
	bool WriteSourceLoc(CCI_SourceLoc* pSourceLoc);
};


#endif
