/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_SERIALIZER_XML_H
#define CCI_SERIALIZER_XML_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_serializer.h"


// -----------------------------------------------------------------------------
// Class CCI_SerializerXml
// -----------------------------------------------------------------------------
class CCI_SerializerXml : public CCI_Serializer
{
	// -------------------------------------------------------------------------
	// Construction & destruction
	// -------------------------------------------------------------------------
public:
	CCI_SerializerXml();
	CCI_SerializerXml(std::string szFileName);


	// -------------------------------------------------------------------------
	// Output stream
	// -------------------------------------------------------------------------
protected:
	virtual std::ios::openmode GetStreamOpenMode();


	// -------------------------------------------------------------------------
	// Serialization
	// -------------------------------------------------------------------------
protected:
	virtual bool WriteCallInfo(LocalFunctionMap* pLocalFunctions, FunctionCallVector* pInitializingCalls, FunctionCallVector* pFinalizingCalls);
};


#endif
