/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_SOURCELOC_H
#define CCI_SOURCELOC_H


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_printable.h"
#include <string>
#include <vector>


// -----------------------------------------------------------------------------
// Class CCI_SourceLoc
// -----------------------------------------------------------------------------
class CCI_SourceLoc : public CCI_Printable
{
	// -------------------------------------------------------------------------
	// Construction
	// -------------------------------------------------------------------------
public:
	// Constructs a CCI_SourceLoc from the specified properties.
	CCI_SourceLoc(std::string szFileName, int iLine, int iColumn, std::string szTranslationUnit);


	// -------------------------------------------------------------------------
	// Properties
	// -------------------------------------------------------------------------
public:
	// Returns the complete file name of the location.
	std::string GetFileName();
	// Returns only the path portion of the file name of the location.
	std::string GetFilePath();
	// Returns only the name portion of the file name of the location.
	std::string GetFileDisplayName();

	// Returns each directory of the file path as an element of the vector.
	void SplitFilePath(std::vector<std::string> & fullDirNames, std::vector<std::string> & dispDirNames);
	// Returns the line number of the location.
	int GetLine();
	// Returns the column number of the location.
	int GetColumn();

	// Returns the fully qualified file name of the translation unit of the location.
	std::string GetTranslationUnit();


	// -------------------------------------------------------------------------
	// Equality
	// -------------------------------------------------------------------------
public:
	// Returns whether this CCI_SourceLoc is equal to the other CCI_SourceLoc.
	// Two CCI_SourceLocs are considered equal iff the following are equal
	// according to the == operator:
	// * m_szFileName, and
	// * m_iLine, and
	// * m_iColumn
	bool operator== (CCI_SourceLoc & other);
	bool operator!= (CCI_SourceLoc & other);


	// -------------------------------------------------------------------------
	// Printable implementation
	// -------------------------------------------------------------------------
public:
	std::string ToString(std::string szPrefix);

	
	// -------------------------------------------------------------------------
	// Helpers
	// -------------------------------------------------------------------------
private:
	void MakeFileNameAbsolute();


	// -------------------------------------------------------------------------
	// State
	// -------------------------------------------------------------------------
private:
	// Contains the filename of the location.
	std::string m_szFileName;
	// Contains the line number of the location.
	int m_iLine;
	// Contains the column number of the location.
	int m_iColumn;
	// Contains the fully qualified file name of the translation unit of the location.
	std::string m_szTranslationUnit;
};


#endif
