/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCI_STRING_TABLE_H
#define CCI_STRING_TABLE_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include <map>
#include <string>


// ----------------------------------------------------------------------------
// Defines
// ----------------------------------------------------------------------------
#define CCI_ST_STRING_NOT_FOUND	-1


// ----------------------------------------------------------------------------
// Class CCI_StringTable
// ----------------------------------------------------------------------------
class CCI_StringTable
{
	// ------------------------------------------------------------------------
	// String management
	// ------------------------------------------------------------------------
public:
	static bool ContainsString(const std::string & szString);
	static bool ContainsIndex(int iIndex);

	static int AddString(const std::string & szString);

	static int Get(const std::string & szString);
	static const std::string* Get(int iIndex);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	static std::map<const std::string, int > m_stringToIndex;
	static std::map<int, const std::string*> m_indexToString;
	static int m_iFirstFreeIndex;
};


#endif
