/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_deserializer.h"
#include "libcci/cci_defines.h"
#include <iostream>


// -----------------------------------------------------------------------------
// Construction & destruction
// -----------------------------------------------------------------------------
CCI_Deserializer::CCI_Deserializer() : m_is(std::cin)
{
	m_bUseFileStream = false;
	m_szFileName = "";
}

CCI_Deserializer::CCI_Deserializer(std::string szFileName) : m_is(m_ifs)
{
	m_bUseFileStream = true;
	m_szFileName = szFileName;
}

// -----------------------------------------------------------------------------
// Output stream
// -----------------------------------------------------------------------------
std::ios::openmode CCI_Deserializer::GetStreamOpenMode()
{
	return std::ios::in;
}


// -----------------------------------------------------------------------------
// Deserialization
// -----------------------------------------------------------------------------
bool CCI_Deserializer::Deserialize(LocalFunctionMap & localFunctions, FunctionCallVector & initializingCalls, FunctionCallVector & finalizingCalls)
{
	if(m_bUseFileStream)
	{
		m_ifs.open(m_szFileName.c_str(), GetStreamOpenMode());
		if(!m_ifs.is_open())
		{
			std::cerr << "Error opening file '" << m_szFileName << "' for reading." << std::endl;
			return false;
		}
	}

	bool bResult = ReadCallInfo(localFunctions, initializingCalls, finalizingCalls);

	if(m_bUseFileStream)
	{
		if(m_ifs.is_open())
			m_ifs.close();
	}

	return bResult;
}

bool CCI_Deserializer::ReadInt(int & iValue)
{
	// Read an integer from the stream.
	int iTheValue;
	CCI_TRY(Read(&iTheValue, sizeof(iTheValue)));
	iValue = iTheValue;

	return true;
}

bool CCI_Deserializer::ReadBool(bool & bValue)
{
	// Read a boolean from the stream.
	bool bTheValue;
	CCI_TRY(Read(&bTheValue, sizeof(bTheValue)));
	bValue = bTheValue;

	return true;
}

bool CCI_Deserializer::ReadString(std::string & szValue)
{
	// Read the size of the string from the stream.
	int iSize;
	CCI_TRY(ReadInt(iSize));

	// Read the string from the stream.
	std::string sz(iSize, 0);
	CCI_TRY(Read(sz.c_str(), iSize));

	// Copy the read string to the supplied string reference.
	szValue = sz;

	return true;
}

bool CCI_Deserializer::Read(void* pValue, int iLength)
{
	m_ifs.read((char*)pValue, iLength);
	return m_ifs.good();
}

bool CCI_Deserializer::Read(const void* pValue, int iLength)
{
	return Read((void*)pValue, iLength);
}
