/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_deserializer_xml.h"
#include "libcci/cci_defines.h"


// -----------------------------------------------------------------------------
// Construction & destruction
// -----------------------------------------------------------------------------
CCI_DeserializerXml::CCI_DeserializerXml() : CCI_Deserializer()
{
}

CCI_DeserializerXml::CCI_DeserializerXml(std::string szFileName) : CCI_Deserializer(szFileName)
{
}


// -----------------------------------------------------------------------------
// Output stream
// -----------------------------------------------------------------------------
std::ios::openmode CCI_DeserializerXml::GetStreamOpenMode()
{
	return CCI_Deserializer::GetStreamOpenMode() | std::ios::binary;
}


// -----------------------------------------------------------------------------
// Deserialization
// -----------------------------------------------------------------------------
bool CCI_DeserializerXml::ReadCallInfo(LocalFunctionMap & localFunctions, FunctionCallVector & initializingCalls, FunctionCallVector & finalizingCalls)
{
	return true;
}
