/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_function_declaration.h"
#include <iostream>
#include <sstream>


// -----------------------------------------------------------------------------
// Construction
// -----------------------------------------------------------------------------
CCI_FunctionDeclaration::CCI_FunctionDeclaration(CCI_SourceLoc* pSourceLoc) :
	CCI_Locatable(pSourceLoc)
{
}


// -----------------------------------------------------------------------------
// Properties
// -----------------------------------------------------------------------------
bool CCI_FunctionDeclaration::operator== (CCI_FunctionDeclaration & other)
{
	return *((CCI_Locatable*)this) == other;
}

bool CCI_FunctionDeclaration::operator!= (CCI_FunctionDeclaration & other)
{
	return *((CCI_Locatable*)this) != other;
}


// -----------------------------------------------------------------------------
// Printable implementation
// -----------------------------------------------------------------------------
std::string CCI_FunctionDeclaration::ToString(std::string szPrefix)
{
	std::stringstream ss;

	ss << szPrefix << "Function declaration"                        << std::endl;
	ss << szPrefix << "{"                                           << std::endl;
	ss << szPrefix << "\tLocation: " << CCI_Locatable::ToString("") << std::endl;
	ss << szPrefix << "}"                                           << std::endl;

	return ss.str();
}
