/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_function_definition.h"
#include "libcci/cci_function_call.h"
#include "libcci/cci_sourceloc.h"
#include "libcci/cci_assert.h"
#include <iostream>
#include <sstream>


// -----------------------------------------------------------------------------
// Construction & destruction
// -----------------------------------------------------------------------------
CCI_FunctionDefinition::CCI_FunctionDefinition(CCI_SourceLoc* pSourceLoc, FunctionCallVector* pFunctionCalls) :
	CCI_Locatable(pSourceLoc),
	m_functionCalls(*pFunctionCalls)
{
}

CCI_FunctionDefinition::~CCI_FunctionDefinition()
{

	// Delete all function calls.
	FunctionCallVector::iterator itFunctionCall = m_functionCalls.begin();
	while(itFunctionCall != m_functionCalls.end())
	{
		delete *itFunctionCall;
		itFunctionCall++;
	}
	m_functionCalls.clear();
}


// -----------------------------------------------------------------------------
// Properties
// -----------------------------------------------------------------------------
FunctionCallVector* CCI_FunctionDefinition::GetFunctionCalls()
{
	return &m_functionCalls;
}


// -----------------------------------------------------------------------------
// Equality
// -----------------------------------------------------------------------------
bool CCI_FunctionDefinition::operator== (CCI_FunctionDefinition & other)
{
	return *((CCI_Locatable*)this) == other;
}

bool CCI_FunctionDefinition::operator!= (CCI_FunctionDefinition & other)
{
	return *((CCI_Locatable*)this) != other;
}


// -----------------------------------------------------------------------------
// Debugging
// -----------------------------------------------------------------------------
std::string CCI_FunctionDefinition::ToString(std::string szPrefix)
{
	std::stringstream ss;
	ss << szPrefix << "Function definition"                         << std::endl;
	ss << szPrefix << "{"                                           << std::endl;
	ss << szPrefix << "\tLocation: " << CCI_Locatable::ToString("") << std::endl;

	// Print the function calls made in this function definition.
	FunctionCallVector::iterator itFunctionCall = m_functionCalls.begin();
	while(itFunctionCall != m_functionCalls.end())
	{
		ss << (*itFunctionCall)->ToString(szPrefix + "\t");
		itFunctionCall++;
	}

	ss << szPrefix << "}"                                           << std::endl;
	return ss.str();
}
