/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_locatable.h"
#include "libcci/cci_sourceloc.h"
#include <assert.h>


// -----------------------------------------------------------------------------
// Construction & destruction
// -----------------------------------------------------------------------------
CCI_Locatable::CCI_Locatable(CCI_SourceLoc* pSourceLoc)
{
	assert(pSourceLoc != NULL);
	m_pSourceLoc = pSourceLoc;
}

CCI_Locatable::~CCI_Locatable()
{
	if(m_pSourceLoc != NULL)
	{
		delete m_pSourceLoc;
		m_pSourceLoc = NULL;
	}
}


// -----------------------------------------------------------------------------
// Properties
// -----------------------------------------------------------------------------
CCI_SourceLoc* CCI_Locatable::GetSourceLoc()
{
	return m_pSourceLoc;
}


// -----------------------------------------------------------------------------
// Equality
// -----------------------------------------------------------------------------
bool CCI_Locatable::operator==(CCI_Locatable & other)
{
	return *m_pSourceLoc == *other.m_pSourceLoc;
}

bool CCI_Locatable::operator!=(CCI_Locatable & other)
{
	return *m_pSourceLoc != *other.m_pSourceLoc;
}


// -----------------------------------------------------------------------------
// Printable implementation
// -----------------------------------------------------------------------------
std::string CCI_Locatable::ToString(std::string szPrefix)
{
	return m_pSourceLoc->ToString(szPrefix);
}
