/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// -----------------------------------------------------------------------------
// Includes
// -----------------------------------------------------------------------------
#include "libcci/cci_sourceloc.h"
#include <sstream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libgen.h>


// -----------------------------------------------------------------------------
// Construction
// -----------------------------------------------------------------------------
CCI_SourceLoc::CCI_SourceLoc(std::string szFileName, int iLine, int iColumn, std::string szTranslationUnit)
{
	m_szFileName        = szFileName;
	m_iLine             = iLine;
	m_iColumn           = iColumn;
	m_szTranslationUnit = szTranslationUnit;

	MakeFileNameAbsolute();
}

void CCI_SourceLoc::MakeFileNameAbsolute()
{
	char szBuffer1[8192];
	char szBuffer2[8192];
	strcpy(szBuffer1, m_szFileName.c_str());
	strcpy(szBuffer2, m_szFileName.c_str());

	char szCurrentPath[8192];
	getcwd(szCurrentPath, 8192);

	chdir(dirname(szBuffer1));

	char szCompletePath[8192];
	getcwd(szCompletePath, 8192);

	chdir(szCurrentPath);
	if(szCompletePath[strlen(szCompletePath) - 1] != '/')
		strcat(szCompletePath, "/");

	strcat(szCompletePath, basename(szBuffer2));

	m_szFileName = szCompletePath;
}


// -----------------------------------------------------------------------------
// Properties
// -----------------------------------------------------------------------------
std::string CCI_SourceLoc::GetFileName()
{
	return m_szFileName;
}

std::string CCI_SourceLoc::GetFilePath()
{
	std::string szFileName;
	szFileName.append(m_szFileName);
	szFileName = dirname((char*)szFileName.c_str());
	return szFileName;
}

std::string CCI_SourceLoc::GetFileDisplayName()
{
	std::string szFileName;
	szFileName.append(m_szFileName);
	szFileName = basename((char*)szFileName.c_str());
	return szFileName;
}

void CCI_SourceLoc::SplitFilePath(std::vector<std::string> & fullDirNames, std::vector<std::string> & dispDirNames)
{
	std::string szFilePath;
	szFilePath.append(GetFilePath());

	std::string szCurrentPath = "";
	fullDirNames.push_back("/");
	dispDirNames.push_back("/");
	char* pszToken = strtok((char*)szFilePath.c_str(), "/");
	while(pszToken != NULL)
	{
		szCurrentPath += "/";
		szCurrentPath += pszToken;
		fullDirNames.push_back(szCurrentPath);
		dispDirNames.push_back(pszToken);
		pszToken = strtok(NULL, "/");
	}
}

int CCI_SourceLoc::GetLine()
{
	return m_iLine;
}

int CCI_SourceLoc::GetColumn()
{
	return m_iColumn;
}

std::string CCI_SourceLoc::GetTranslationUnit()
{
	return m_szTranslationUnit;
}


// -----------------------------------------------------------------------------
// Equality
// -----------------------------------------------------------------------------
bool CCI_SourceLoc::operator== (CCI_SourceLoc & other)
{
	return (m_szFileName == other.m_szFileName) &&
		   (m_iLine      == other.m_iLine     ) &&
		   (m_iColumn    == other.m_iColumn   );
}

bool CCI_SourceLoc::operator!= (CCI_SourceLoc & other)
{
	return (m_szFileName != other.m_szFileName) ||
		   (m_iLine      != other.m_iLine     ) ||
		   (m_iColumn    != other.m_iColumn   );
}


// -----------------------------------------------------------------------------
// Printable implementation
// -----------------------------------------------------------------------------
std::string CCI_SourceLoc::ToString(std::string szPrefix)
{
	std::stringstream ss;

	ss << szPrefix << "(Ln: " << m_iLine << ", Cl: " << m_iColumn << ", " << m_szFileName << ", " << m_szTranslationUnit << ")";

	return ss.str();
}
