/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "libcci/cci_string_table.h"


// ----------------------------------------------------------------------------
// Static member declarations
// ----------------------------------------------------------------------------
std::map<const std::string, int > CCI_StringTable::m_stringToIndex;
std::map<int, const std::string*> CCI_StringTable::m_indexToString;
int CCI_StringTable::m_iFirstFreeIndex = 0;


// ----------------------------------------------------------------------------
// String management
// ----------------------------------------------------------------------------
bool CCI_StringTable::ContainsString(const std::string & szString)
{
	return m_stringToIndex.find(szString) != m_stringToIndex.end();
}

bool CCI_StringTable::ContainsIndex(int iIndex)
{
	return m_indexToString.find(iIndex) != m_indexToString.end();
}

int CCI_StringTable::AddString(const std::string & szString)
{
	// If the string is already present in the string table, simply return the
	// existing entry.
	if(ContainsString(szString))
		return Get(szString);

	// The string does not exist yet in the string table, so add it now.
	m_stringToIndex[szString] = m_iFirstFreeIndex;
	m_indexToString[m_iFirstFreeIndex] = &m_stringToIndex.find(szString)->first;
}

int CCI_StringTable::Get(const std::string & szString)
{
	// If the supplied string does not exist in the string table, return the
	// appropriate error code.
	if(!ContainsString(szString))
		return CCI_ST_STRING_NOT_FOUND;

	// The string exists in the string table, so return its index.
	return m_stringToIndex[szString];
}

const std::string* CCI_StringTable::Get(int iIndex)
{
	if(!ContainsIndex(iIndex))
		return NULL;

	return m_indexToString[iIndex];
}
