/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ccie.h"
#include "ccie_definition_visitor.h"
#include "ccie_declaration_visitor.h"
#include "ccie_static_call_visitor.h"
#include "ccie_linkage_semantics.h"
#include "ccie_call_validator.h"
#include "ccie_declaration_filter.h"
#include "ccie_definition_filter.h"
#include "ccie_verbose_printing.h"
#include <libcci/cci.h>
#include "oink_global.h"
#include <iomanip>


void CCIE::extract_stage()
{
	foreachSourceFile
	{
		File* file = files.data();

		maybeSetInputLangFromSuffix(file);
		CCIE_TranslationUnitInfo::m_szSourceFileName = file->name;
		CCIE_TranslationUnitInfo::m_pTranslationUnit = file2unit.get(file);
		//m_tuInfo.m_szSourceFileName = file->name;
		//m_tuInfo.m_pTranslationUnit = file2unit.get(file);
		ProcessTranslationUnit();
	}
}
//*
void CCIE::ProcessTranslationUnit()
{
	// Extract all function definitions, function declarations and function calls.
	Extract();

	// Perform validation.
//	Validate();

	// Construct the call-candidate mappings.
	ResolveCallCandidates();
	
	// Filter out functions that are never interesting.
	Filter();

	// Apply linkage semantics.
	ApplyLinkageSemantics();

	// Perform validation.
//	Validate();

	// Perform validation again.
	Validate();

	// Serialize the call information.
	Serialize();

	// Debug printing.
	Print();
}
/*/
void CCIE::ProcessTranslationUnit()
{
	// Extract all function definitions, function declarations and function calls.
	Extract();

	// Perform validation.
	Validate();

	// Construct the call-candidate mappings.
	ResolveCallCandidates();

	// Apply linkage semantics.
	ApplyLinkageSemantics();

	// Perform validation.
	Validate();

	// Filter out functions that are never interesting.
	Filter();

	// Perform validation again.
	Validate();

	// Serialize the call information.
	Serialize();

	// Debug printing.
	Print();
}
/**/
void CCIE::Extract()
{
	// Extract all function definitions from this TranslationUnit.
	VERBOSE_PRINT("Extracting function definitions...");
	CCIE_DefinitionVisitor definitionVisitor/*(m_tuInfo)*/;
	definitionVisitor.Traverse();

	// Extract all function declarations from this TranslationUnit.
	VERBOSE_PRINT("Extracting function declarations...");
	CCIE_DeclarationVisitor declarationVisitor/*(m_tuInfo)*/;
	declarationVisitor.Traverse();

	// Find the remaining static initializer calls.
	VERBOSE_PRINT("Extracting initializing/finalizing calls...");
	CCIE_StaticCallVisitor staticCallVisitor/*(m_tuInfo)*/;
	staticCallVisitor.Traverse();
}

void CCIE::ResolveCallCandidates()
{
	VERBOSE_PRINT("Resolving mappings...");
	CCIE_TranslationUnitInfo::m_callCandidates.Resolve(CCIE_TranslationUnitInfo::m_localFunctionRepository.GetFunctions());
}

void CCIE::ApplyLinkageSemantics()
{
	// Mangle all signatures of functions, and calls made to them, that have
	// static linkage.
	VERBOSE_PRINT("Applying linkage semantics...");
	CCIE_LinkageSemantics::MangleStaticLinkageSignatures(/*m_tuInfo*/);
}

void CCIE::Validate()
{
	// Validate that all functions that are called from this translation unit
	// have at least been declared.
	VERBOSE_PRINT("Validating that all called functions have been declared...");
	CCIE_CallValidator::ValidateAvailability(/*m_tuInfo*/);

	// Validate that we indeed found all function calls.
	// Validating completeness does not work properly with the mangled names of
	// functions with static linkage.
	//CCIE_CallValidator::ValidateCompleteness(/*m_tuInfo*/);

	// Validate that the signatures of the functions in the repository are
	// equal to the keys under which they are made available.
	VERBOSE_PRINT("Validating that all functions are published correctly...");
	CCIE_CallValidator::ValidateIntegrity(/*m_tuInfo*/);
}

void CCIE::Filter()
{
	if(!CCIE_Cmd::FilterDeclarations() && !CCIE_Cmd::FilterDefinitions())
		return;

	int iFunctionCount1 = CCIE_TranslationUnitInfo::m_localFunctionRepository.GetFunctions()->size();
	VERBOSE_PRINT("Number of functions before filtering: " << iFunctionCount1);

	if(CCIE_Cmd::FilterDeclarations())
	{
		// Filter out all functions that only have a declaration and that are never
		// called from this translation unit.
		CCIE_DeclarationFilter::Filter(/*m_tuInfo*/);
	}

	int iFunctionCount2 = CCIE_TranslationUnitInfo::m_localFunctionRepository.GetFunctions()->size();
	VERBOSE_PRINT("Filtered " << (iFunctionCount1 - iFunctionCount2) << " unused declaration-only functions...");

	if(CCIE_Cmd::FilterDefinitions())
	{
		// Filter out all functions that have static linkage and that are never
		// called, directly or indirectly, by any of the functions that have been
		// specified as the entry points.
		CCIE_DefinitionFilter::Filter(/*m_tuInfo*/);
	}

	int iFunctionCount3 = CCIE_TranslationUnitInfo::m_localFunctionRepository.GetFunctions()->size();
	VERBOSE_PRINT("Filtered " << (iFunctionCount2 - iFunctionCount3) << " unused functions with static linkage...");
	VERBOSE_PRINT("Number of functions after filtering: " << iFunctionCount3);
	VERBOSE_PRINT("Discarded " << std::setiosflags(std::ios::fixed) << std::setprecision(2) << (100.0f - (100.0f / iFunctionCount1 * iFunctionCount3)) << "% of all functions.");
	VERBOSE_PRINT("Filter factor is " << ((float)iFunctionCount1 / iFunctionCount3));
}

void CCIE::Serialize()
{
	std::string szOutputFileName = CCIE_Cmd::OutputFileName();
	szOutputFileName = (szOutputFileName == "") ? (CCIE_TranslationUnitInfo::m_szSourceFileName + ".cci") : szOutputFileName;

	bool bResult = false;

	switch(CCIE_Cmd::OutputType())
	{
		case CCIE_Cmd::CCIE_OT_Binary:
		{
			VERBOSE_PRINT("Serializing as binary output...");
			CCI_SerializerBin serializer(szOutputFileName);
			bResult = serializer.Serialize(CCIE_TranslationUnitInfo::m_localFunctionRepository.GetFunctions(), &CCIE_TranslationUnitInfo::m_initializingCalls, &CCIE_TranslationUnitInfo::m_finalizingCalls);
			break;
		}
		case CCIE_Cmd::CCIE_OT_Xml:
		{
			VERBOSE_PRINT("Serializing as XML output...");
			CCI_SerializerXml serializer(szOutputFileName + ".xml");
			bResult = serializer.Serialize(CCIE_TranslationUnitInfo::m_localFunctionRepository.GetFunctions(), &CCIE_TranslationUnitInfo::m_initializingCalls, &CCIE_TranslationUnitInfo::m_finalizingCalls);
			break;
		}
	}

	if(!bResult)
	{
		std::cerr << "An error occurred while serializing the translation unit." << std::endl;
	}
}


// ----------------------------------------------------------------------------
// Debugging
// ----------------------------------------------------------------------------
void CCIE::Print()
{
	if(CCIE_Cmd::PrintCallInformation())
	{
		VERBOSE_PRINT("Printing extracted call information...");
		CCIE_TranslationUnitInfo::Print("");
	}
}
