/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_H
#define CCIE_H


#include "oink.h"
#include "ccie_cmd.h"
#include "ccie_translation_unit_info.h"


class CCIE : public virtual Oink
{
	// ------------------------------------------------------------------------
	// Extraction
	// ------------------------------------------------------------------------
public:
	void extract_stage();

private:

	void ProcessTranslationUnit();

	void Extract();
	void ResolveCallCandidates();
	void ApplyLinkageSemantics();
	void Validate();
	void Filter();
	void Serialize();


	// ------------------------------------------------------------------------
	// Debugging
	// ------------------------------------------------------------------------
private:
	void Print();


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	//CCIE_TranslationUnitInfo m_tuInfo;
};


#endif
