/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_CALL_VALIDATOR_H
#define CCIE_CALL_VALIDATOR_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_translation_unit_info.h"
#include "ccie_local_function_repository.h"
#include "cc_ast.h"


// ----------------------------------------------------------------------------
// Class CCIE_CallValidator
// ----------------------------------------------------------------------------
class CCIE_CallValidator
{
	// ------------------------------------------------------------------------
	// Static accessor for convenience
	// ------------------------------------------------------------------------
public:
	static void ValidateAvailability(/*CCIE_TranslationUnitInfo & tuInfo*/);
	static void ValidateCompleteness(/*CCIE_TranslationUnitInfo & tuInfo*/);
	static void ValidateIntegrity(/*CCIE_TranslationUnitInfo & tuInfo*/);


	// ------------------------------------------------------------------------
	// Construction & destruction
	// ------------------------------------------------------------------------
private:
	CCIE_CallValidator(/*CCIE_TranslationUnitInfo & tuInfo*/);
	~CCIE_CallValidator();


	// ------------------------------------------------------------------------
	// Availability validation
	// ------------------------------------------------------------------------
private:
	void _ValidateAvailability();
	void ValidateLocalFunction(CCI_LocalFunction* pLocalFunction);
	void ValidateFunctionCall(CCI_FunctionCall* pFunctionCall);
	void ReportFunctionNotFound(CCI_FunctionCall* pFunctionCall);


	// ------------------------------------------------------------------------
	// Completeness validation
	// ------------------------------------------------------------------------
	// NOTE: Completeness validation does not correctly handle mangled names
	//       (for static linkage) at the moment.
	void _ValidateCompleteness();
	int CountFoundFunctionCalls();
	int CountActualFunctionCalls();

	void PrintMissingFunctionCalls();
	void DeleteFunctionCall(CCI_FunctionCall* pFunctionCall);


	// ------------------------------------------------------------------------
	// Integrity validation
	// ------------------------------------------------------------------------
private:
	void _ValidateIntegrity();


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	//CCIE_TranslationUnitInfo & m_tuInfo;
	//TranslationUnit* m_pTranslationUnit;
	//CCIE_LocalFunctionRepository* m_pLocalFunctionRepository;
	//FunctionCallVector* m_pInitializingCalls;
	//FunctionCallVector* m_pFinalizingCalls;

	FunctionCallVector m_actualFunctionCalls;
};


#endif

