/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_call_visitor.h"
#include "ccie_function_call_factory.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Construction
// ----------------------------------------------------------------------------
CCIE_CallVisitor::CCIE_CallVisitor(FunctionCallVector* pFunctionCalls) : m_loweredVisitor(this)
{
	cci_assert(pFunctionCalls != NULL);
	m_pFunctionCalls = pFunctionCalls;
}


// ----------------------------------------------------------------------------
// Traversal
// ----------------------------------------------------------------------------
void CCIE_CallVisitor::Traverse(TranslationUnit* pTranslationUnit)
{
	cci_assert(pTranslationUnit != NULL);
	pTranslationUnit->traverse(m_loweredVisitor);
}

void CCIE_CallVisitor::Traverse(Function* pFunction)
{
	cci_assert(pFunction != NULL);
	pFunction->traverse(m_loweredVisitor);
}

void CCIE_CallVisitor::Traverse(Initializer* pInitializer)
{
	cci_assert(pInitializer != NULL);
	pInitializer->traverse(m_loweredVisitor);
}

void CCIE_CallVisitor::Traverse(Statement* pStatement)
{
	cci_assert(pStatement != NULL);
	pStatement->traverse(m_loweredVisitor);
}


// ----------------------------------------------------------------------------
// ASTVisitor implementation
// ----------------------------------------------------------------------------
bool CCIE_CallVisitor::visitExpression(Expression* pExpression)
{
	cci_assert_allow(pExpression != NULL);
	if(pExpression == NULL)
		return true;

	if(pExpression->isE_funCall())
	{	
		// Determine what type of function is being called here.
		E_funCall* pE_funCall = pExpression->asE_funCall();

		//if(pE_funCall->func->isE_deref())
		//{
			//std::cerr << "{{{{{{{{{{\n";
			//pExpression->debugPrint(std::cerr, 0);
			//std::cerr << "}}}}}}}}}}\n";
		//}
		CCIE_FunctionCallFactory::Create(m_pFunctionCalls, m_loweredVisitor.getLoc(), pE_funCall->func);

		//CCI_FunctionCall* pFunctionCall = CCIE_FunctionCallFactory::Create(m_loweredVisitor.getLoc(), pE_funCall->func);
		//if(pFunctionCall != NULL)
		//	m_pFunctionCalls->push_back(pFunctionCall);
	}
	else  if(pExpression->isE_constructor())
	{
		
		CCIE_FunctionCallFactory::Create(m_pFunctionCalls, m_loweredVisitor.getLoc(), pExpression->asE_constructor());

//		CCI_FunctionCall* pFunctionCall = CCIE_FunctionCallFactory::Create(m_loweredVisitor.getLoc(), pExpression->asE_constructor());
//		if(pFunctionCall != NULL)
//			m_pFunctionCalls->push_back(pFunctionCall);
	}

	/*
	// Check whether this expression is a function call.
	if(pExpression->isE_funCall())
	{
		// Determine what type of function is being called here.
		E_funCall* pE_funCall = pExpression->asE_funCall();

		Expression* pFuncExpression = pE_funCall->func;
		cci_assert(pFuncExpression != NULL);

		if(pFuncExpression->isE_variable())
		{
			// This is a call to a 'free' (non-method) function.
			E_variable* pE_variable = pFuncExpression->asE_variable();

			Variable* pVariable = pE_variable->var;
			
			// When in 'permissive' mode, every now and then pVariable is NULL.
			// This seems to be caused by compiler builtins like
			// '__synch_fetch_and_add'. This is in fact an error, but since we
			// are in permissive mode, it is tolerated. We cannot do anything
			// with this function call however, so ignore it.
			if(pVariable != NULL)
			{
				AddFunctionCall(pVariable);
			}
		}
		else if(pFuncExpression->isE_fieldAcc())
		{
			// This is a call to a 'field accessor'. Known accessors:
			// * Destructor
			// * Operator=
			// * Method call through object pointer or object reference.
			E_fieldAcc* pE_fieldAcc = pFuncExpression->asE_fieldAcc();
			AddFunctionCall(pE_fieldAcc->field, pE_fieldAcc->obj);
		}
		else if(pFuncExpression->isE_binary())
		{
			// This is a call through a pointer-to-member.
			E_binary* pE_binary = pFuncExpression->asE_binary();

			Expression* pEx2 = pE_binary->e2;
			cci_assert(pEx2 != NULL);

			if(pEx2->isE_variable())
			{
				E_variable* pE_variable = pEx2->asE_variable();

				Variable* pVariable = pE_variable->var;
				cci_assert(pVariable != NULL);

				AddFunctionCall(pVariable);
			}
		}
		else if(pFuncExpression->isE_deref())
		{
			// Apparently, we have a pointer to an object or a function pointer.
			// Whichever is the case, we need to dig down further by recursing
			// into the thing that the pointer points at.
			Expression* pExpr = pFuncExpression;
			while(pExpr->isE_deref())
			{
				std::cerr << "DEREF!!\n";
				pExpr = pExpr->asE_deref()->ptr;
			}
			
		}
	}

	// Check whether this expression is a constructor call.
	else if(pExpression->isE_constructor())
	{
		E_constructor* pE_constructor = pExpression->asE_constructor();

		Variable* pVariable = pE_constructor->ctorVar;
		
		// Every now and then pVariable is NULL. It seem that this occurs when
		// a C-struct is copied, e.g., as a return value. For some reason, elsa
		// indicates that as a constructor expression, but without a ctorVar.
		// It makes sense that there is no constructor though, since it is a C-
		// struct, not a C++-struct.
		if(pVariable != NULL)
		{
			AddFunctionCall(pVariable);
		}
	}
	*/

	return true;
}

/*
void CCIE_CallVisitor::AddFunctionCall(Variable* pVariable)
{
	cci_assert(pVariable != NULL);
	cci_assert(m_pFunctionCalls != NULL);

	// Create a new CCI_FunctionCall object for this function call and add it to
	// the vector of function calls.
	m_pFunctionCalls->push_back(CCIE_FunctionCallFactory::Create(m_loweredVisitor.getLoc(), pVariable));
}

void CCIE_CallVisitor::AddFunctionCall(Variable* pVariable, Expression* pObject)
{
	cci_assert(pVariable != NULL);
	cci_assert(pObject != NULL);
	cci_assert(m_pFunctionCalls != NULL);

	// Create a new CCI_FunctionCall object for this function call and add it to
	// the vector of function calls.
	m_pFunctionCalls->push_back(CCIE_FunctionCallFactory::Create(m_loweredVisitor.getLoc(), pVariable, pObject));
}
*/
