/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_CALL_VISITOR_H
#define CCIE_CALL_VISITOR_H


// ============================================================================
// The Call Visitor
// ============================================================================
//
// Description
// ===========
//
// The call visitor is responsible for extracting all the functions calls in
// a function. It does this by implementing the ASTVisitor interface and
// investigating the AST nodes it visits.
//
// When a function call is found, its signature is extracted and a new
// HH_FunctionCall object is created to represent the call. A mapping from the
// signature to the HH_FunctionCall object is then added to the
// FunctionCallVector supplied during construction.
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"
#include "cc_ast_aux.h"
//#include "ci_typedefs.h"
#include <libcci/cci.h>
#include <vector>


// ----------------------------------------------------------------------------
// Class CCIE_CallVisitor
// ----------------------------------------------------------------------------
class CCIE_CallVisitor : public ASTVisitor
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	CCIE_CallVisitor(FunctionCallVector* pFunctionCalls);

	
	// ------------------------------------------------------------------------
	// Traversal
	// ------------------------------------------------------------------------
public:
	void Traverse(TranslationUnit* pTranslationUnit);
	void Traverse(Function* pFunction);
	void Traverse(Initializer* pInitializer);
	void Traverse(Statement* pStatement);


	// ------------------------------------------------------------------------
	// ASTVisitor implementation
	// ------------------------------------------------------------------------
private:
	virtual bool visitExpression(Expression* pExpression);

private:
	void AddFunctionCall(Variable* pVariable);
	void AddFunctionCall(Variable* pVariable, Expression* pObject);


	// ------------------------------------------------------------------------
	// State
	// ------------------------------------------------------------------------
private:
	// The LoweredASTVisitor to be used for traversals.
	LoweredASTVisitor m_loweredVisitor;
	// Pointer to the vector that will contain all function calls found in the
	// AST subtree to which this ASTVisitor is applied.
	FunctionCallVector* m_pFunctionCalls;
};


#endif
