/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_CMD_H
#define CCIE_CMD_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "oink_cmd.h"
#include "oink_file.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Class CCIE_Cmd
// ----------------------------------------------------------------------------
class CCIE_Cmd : public virtual OinkCmd
{
	// ------------------------------------------------------------------------
	// Enums
	// ------------------------------------------------------------------------
public:
	enum CCIE_OutputType
	{
		CCIE_OT_Binary,
	 	CCIE_OT_Xml
	};


	// ------------------------------------------------------------------------
	// OinkCmd overrides
	// ------------------------------------------------------------------------
public:
	virtual void readOneArg(int &argc, char **&argv);
	virtual void dump();
	virtual void printHelp();


	// ------------------------------------------------------------------------
	// Properties
	// ------------------------------------------------------------------------
public:
	static std::string OutputFileName();
	static CCIE_OutputType OutputType();
	static StringVector* FilterDefinitionsKeepSignatures();
	static bool FilterDeclarations();
	static bool FilterDefinitions();
	static bool FilterDefinitionsConservative();
	static bool PrintCallInformation();
	static bool PrintConservativenessWarnings();
	static bool PrintDebugInformation();
	static bool Verbose();


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	static std::string m_szOutputFileName;
	static CCIE_OutputType m_outputType;
	static StringVector m_filterDefinitionsKeepSignatures;
	static bool m_bFilterDeclarations;
	static bool m_bFilterDefinitions;
	static bool m_bFilterDefinitionsConservative;
	static bool m_bPrintCallInformation;
	static bool m_bPrintConservativenessWarnings;
	static bool m_bPrintDebugInformation;
	static bool m_bVerbose;
};


#endif
