/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_declaration_visitor.h"
#include "ccie_local_function_repository.h"
#include "ccie_function_signature.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Construction
// ----------------------------------------------------------------------------
CCIE_DeclarationVisitor::CCIE_DeclarationVisitor(/*CCIE_TranslationUnitInfo & tuInfo*/) :
	m_loweredVisitor(this)/*,
	m_tuInfo(tuInfo)*/
{
}


// ----------------------------------------------------------------------------
// Traversal
// ----------------------------------------------------------------------------
void CCIE_DeclarationVisitor::Traverse()
{
	cci_assert(CCIE_TranslationUnitInfo::m_pTranslationUnit != NULL);
	CCIE_TranslationUnitInfo::m_pTranslationUnit->traverse(m_loweredVisitor);
}


// ----------------------------------------------------------------------------
// ASTVisitor implementation
// ----------------------------------------------------------------------------
bool CCIE_DeclarationVisitor::visitDeclarator(Declarator* pDeclarator)
{
	cci_assert(pDeclarator != NULL);

	if(pDeclarator->var != NULL)
	{
		Variable* pVariable = pDeclarator->var;
		cci_assert(pVariable->type != NULL);

		if(pVariable->type->isFunctionType())
		{
			CCIE_TranslationUnitInfo::m_localFunctionRepository.AddFunction(pVariable);
		}
	}

	return true;
}
