/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_DEFINITION_FILTER_H
#define CCIE_DEFINITION_FILTER_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_translation_unit_info.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// CCIE_DefinitionFilter
// ----------------------------------------------------------------------------
class CCIE_DefinitionFilter
{
	// ------------------------------------------------------------------------
	// Static accessor for convenience
	// ------------------------------------------------------------------------
public:
	static void Filter(/*CCIE_TranslationUnitInfo & tuInfo*/);


	// ------------------------------------------------------------------------
	// Construction & destruction
	// ------------------------------------------------------------------------
private:
	CCIE_DefinitionFilter(/*CCIE_TranslationUnitInfo & tuInfo*/);


	// ------------------------------------------------------------------------
	// Filtering
	// ------------------------------------------------------------------------
private:
	void _Filter();

	void CalculateFunctionSet();
	void CalculateCallableSet();
	void CalculateInitialCallableSet();
	void CalculateCallableSetClosure();
	void AddCallablesFromFunction(std::string szSignature);
	void WarnIfNecessary(std::string szSignature);


	// ------------------------------------------------------------------------
	// Debugging
	// ------------------------------------------------------------------------
private:
//	void Print(std::string prefix);
	void PrintCallableSet(std::string szPrefix, std::string szMessage);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	//CCIE_TranslationUnitInfo & m_tuInfo;

	StringSet m_callables;
	StringSet m_functions;
};


#endif
