/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_FUNCTION_DECLARATION_FACTORY_H
#define CCIE_FUNCTION_DECLARATION_FACTORY_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"
#include "ccie_function_signature.h"
#include "ccie_sourceloc_factory.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Class CCIE_FunctionDeclarationFactory
// ----------------------------------------------------------------------------
class CCIE_FunctionDeclarationFactory
{
	// ------------------------------------------------------------------------
	// Creation
	// ------------------------------------------------------------------------
public:
	static CCI_FunctionDeclaration* Create(Variable* pVariable)
	{
		// Assert the supplied parameter.
		cci_assert(pVariable != NULL);
		cci_assert(pVariable->type != NULL);
		cci_assert(pVariable->type->isFunctionType());

		// Create and return a new CCI_FunctionDeclaration, containing a new
		// CC_SourceLoc.
		return new CCI_FunctionDeclaration(CCIE_SourceLocFactory::Create(pVariable));
	}
};


#endif
