/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_FUNCTION_DEFINITION_FACTORY_H
#define CCIE_FUNCTION_DEFINITION_FACTORY_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"
#include "cc_ast_aux.h"
#include "ccie_function_signature.h"
#include "ccie_sourceloc_factory.h"
#include "ccie_call_visitor.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Class CCIE_FunctionDefinitionFactory
// ----------------------------------------------------------------------------
class CCIE_FunctionDefinitionFactory
{
	// ------------------------------------------------------------------------
	// Creation
	// ------------------------------------------------------------------------
public:
	static CCI_FunctionDefinition* Create(Function* pFunction)
	{
		cci_assert(pFunction != NULL);

		// Initialize members.
		CCI_SourceLoc* pSourceLoc = CCIE_SourceLocFactory::Create(pFunction);

		// Extract the function calls made in this function definition.
		FunctionCallVector functionCalls;
		CCIE_CallVisitor callVisitor(&functionCalls);
		callVisitor.Traverse(pFunction);

		// Create and return a new CCI_FunctionDefinition, based on the
		// CCI_SourceLoc and the extracted function calls.
		return new CCI_FunctionDefinition(pSourceLoc, &functionCalls);
	}
};


#endif
