/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_function_signature.h"
#include "ccie_debug_printing.h"
#include <libcci/cci.h>
//#include "mangle.h"
#include <iostream>
#include <sstream>



// TODO: Implement customer scope/namespace tracing/printing.
//       The current implementation sometimes causes as assertion failure
//       saying that "fullyQualifiedName was called on a scope that does not
//       terminate in the global scope".

// TODO: Make sure "pType->isArrayType" is handled correctly in
//       GetSignature(Type*). Also check the other left over types.


/*
// ----------------------------------------------------------------------------
// Class Signature
// ----------------------------------------------------------------------------
std::string CCIE_FunctionSignature::GetSignature(Function* pFunction)
{
	assert(pFunction != NULL);
	assert(pFunction->nameAndParams != NULL);
	return GetSignature(pFunction->nameAndParams->var);
}

std::string CCIE_FunctionSignature::GetSignature(Variable* pVariable)
{
	assert(pVariable != NULL);
	std::string left  = leftMangle(pVariable->type, false).c_str();
	std::string right = rightMangle(pVariable->type, false).c_str();
	std::string name = GetFullyQualifiedName(pVariable);
	std::string signature = left + name + right;

	// Detect partial specialization.
	std::string vfqn = pVariable->fullyQualifiedName0().c_str();
	if(name != vfqn)
	{
		signature += "|" + vfqn;
	}
	
	std::cout << "------------------------------------------------" << std::endl;
	std::cout << "OLD SIGNATURE: " << signature << std::endl;
	std::cout << "NEW SIGNATURE: " << CCIE_NewFunctionSignature::GetSignature(pVariable) << std::endl;

	return signature;
}

std::string CCIE_FunctionSignature::GetCallSignature(Function* pFunction)
{
	assert(pFunction != NULL);
	assert(pFunction->nameAndParams);

	return GetCallSignature(pFunction->nameAndParams->var);
}

std::string CCIE_FunctionSignature::GetCallSignature(Variable* pVariable)
{
	assert(pVariable != NULL);
	assert(pVariable->type != NULL);

	return GetCallSignature(pVariable->type);
}

std::string CCIE_FunctionSignature::GetCallSignature(Type* pType)
{
	assert(pType != NULL);
	assert(pType->isFunctionType());

	FunctionType* pFunctionType = pType->asFunctionType();
	std::string szCallSignature;
	if(pFunctionType->isMethod())
	{
		// If this type represents a class method, then we need to print the
		// name of the class in the call signature.
		szCallSignature = GetCallSignatureWithClassName(pType, pFunctionType->getClassOfMember()->toString().c_str());
	}
	else if(pFunctionType->isConstructor())
	{
		// If this type represents a class constructor, then we need to print
		// the name of the class in the call signature.
		szCallSignature = GetCallSignatureWithClassName(pType, pFunctionType->retType->toString().c_str());
	}
	else
	{
		// This is a plain c-style function. Simply return the signature of the
		// type, stripped of any identifier names.
		szCallSignature = mangle(pType).c_str();
	}
	
	std::cout << "------------------------------------------------" << std::endl;
	std::cout << "OLD CALL SIGNATURE: " << szCallSignature << std::endl;
	std::cout << "NEW CALL SIGNATURE: " << CCIE_NewFunctionSignature::GetCallSignature(pType) << std::endl;
	
	return szCallSignature;
}

std::string CCIE_FunctionSignature::GetFullyQualifiedName(Variable* pVariable)
{
	assert(pVariable != NULL);

	Type* pType = pVariable->type;
	if(pType->isFunctionType())
	{
		FunctionType* pFunctionType = pType->asFunctionType();
		if(pFunctionType->isMethod() || pFunctionType->isConstructor())
		{
			return GetClassSignature(pFunctionType) + "::" + GetNameWithoutConversionOperator(pVariable);
		}
		else
		{
			// This is a plain c-style function, so partial template
			// specialization is not possible here. Therefore, we can safely
			// use Variable::fullyQualifiedName0() to construct the fully
			// qualified name.
			return pVariable->fullyQualifiedName0().c_str();
		}
	}

	std::cout << "SIGNATURE: " << pVariable->toQualifiedString().c_str() << std::endl;

	assert(false);
	return "";
}

std::string CCIE_FunctionSignature::GetClassSignature(FunctionType* pFunctionType)
{
	assert(pFunctionType != NULL);

	if(pFunctionType->isMethod())
	{
		// If this type represents a class method, then we need to print the
		// name of the class in the call signature.
		return StripContainer(pFunctionType->getClassOfMember()->toString().c_str());
	}
	else if(pFunctionType->isConstructor())
	{
		// If this type represents a class constructor, then we need to print
		// the name of the class in the call signature.
		return StripContainer(pFunctionType->retType->toString().c_str());
	}

	assert(false);
	return "";
}

std::string CCIE_FunctionSignature::GetCallSignatureWithClassName(Type* pType, std::string className)
{
	assert(pType != NULL);
	return leftMangle(pType).c_str() + className + "::*" + rightMangle(pType).c_str();
}

std::string CCIE_FunctionSignature::GetNameWithoutConversionOperator(Variable* pVariable)
{
	assert(pVariable != NULL);

	if(streq(pVariable->name, "conversion-operator"))
		return std::string("operator ") + pVariable->type->asFunctionTypeC()->retType->toString().c_str();
	else
		return pVariable->name;
}

std::string CCIE_FunctionSignature::StripContainer(std::string signature)
{
	if(signature.find("class ") == 0)
	{
		std::string tmp(signature, 6);
		signature = tmp;
	}
	else if(signature.find("struct ") == 0)
	{
		std::string tmp(signature, 7);
		signature = tmp;
	}
	else if(signature.find("union ") == 0)
	{
		std::string tmp(signature, 6);
		signature = tmp;
	}

	return signature;
}
*/



// --------------------------------------------------------------------------------------------------------------------------------------------------------
// NEW
// --------------------------------------------------------------------------------------------------------------------------------------------------------



std::string CCIE_FunctionSignature::GetSignature(Function* pFunction)
{
	cci_assert(pFunction != NULL);
	cci_assert(pFunction->nameAndParams != NULL);
	return GetSignature(pFunction->nameAndParams->var);
}

std::string CCIE_FunctionSignature::GetCallSignature(Function* pFunction)
{
	cci_assert(pFunction != NULL);
	cci_assert(pFunction->nameAndParams);
	return GetCallSignature(pFunction->nameAndParams->var);
}

std::string CCIE_FunctionSignature::GetCallSignature(Variable* pVariable)
{
	cci_assert(pVariable != NULL);
	return GetCallSignature(pVariable->type);
}

std::string CCIE_FunctionSignature::GetCallSignature(Type* pType)
{
	cci_assert(pType != NULL);
	//return GetSignature(pType, "*");
	return GetSignature(pType);
}

std::string CCIE_FunctionSignature::GetSignature(Variable* pVariable)
{
	cci_assert(pVariable != NULL);

	/*
		return GetSignature(pVariable->type, pVariable->name, pVariable->scope->fullyQualifiedName().c_str());
	/*/
		 //Scope* pScope = pVariable->getDenotedScope();
		 Scope* pScope = pVariable->scope;
		 if(pScope == NULL)
		 {
		 	DEBUG_PRINT("SCOPE == NULL: " << pVariable->name);
		 }
		 return GetSignature(pVariable->type, pVariable->name, GetScopeName(pScope));
	/**/
}

std::string CCIE_FunctionSignature::GetSignature(Type* pType, std::string szFunctionName, std::string szContainer)
{
	cci_assert(pType != NULL);

	std::string szSignature = ToString(pType->getCVFlags());
	if(pType->isFunctionType())
	{
		szSignature += GetSignature(pType->asFunctionType(), szFunctionName, szContainer);
	}
	else if(pType->isPointerType())
	{
		szSignature += GetSignature(pType->asPointerType());
	}
	else if(pType->isReferenceType())
	{
		szSignature += GetSignature(pType->asReferenceType());
	}
	else if(pType->isPointerToMemberType())
	{
		szSignature += GetSignature(pType->asPointerToMemberType());
	}
	else if(pType->isCVAtomicType())
	{
		szSignature += GetSignature(pType->asCVAtomicType());
	}
	else if(pType->isArrayType())
	{
		// TODO: Make sure this is correct
		szSignature += pType->toString().c_str();
	}
	else
	{
		cci_assert(false);
		szSignature += "UnknownType";
	}

	return szSignature;
}

std::string CCIE_FunctionSignature::GetSignature(FunctionType* pFunctionType, std::string szVariableName, std::string szContainer)
{
	cci_assert(pFunctionType != NULL);
	
	// Check what kind of function this is. It can be either:
	// * A Method (includes conversion operators)
	// * A Constructor
	// * A Destructor
	// * A C-style function
	if(pFunctionType->isMethod())
	{
		if(szVariableName[0] == '~')
		{
			// This is a destructor.

			std::string szContainer = GetSignature(pFunctionType->getClassOfMember());
			std::string szParams = "";
			SFOREACH_OBJLIST(Variable, pFunctionType->params, iter)
			{
				const Variable* pVariable = iter.data();
				if(szParams != "")
					szParams += ", ";
				szParams += GetSignature(pVariable->type); // Do not supply the name of the parameter, since we don't care about it.
			}

			return "(" + szContainer + "::" + szVariableName + ")(" + szParams + ")";

		}
		else
		{
			// This is a method.

			std::string szReturnType = GetSignature(pFunctionType->retType);
			std::string szContainer = GetSignature(pFunctionType->getClassOfMember());
			std::string szParams = "";
			SFOREACH_OBJLIST(Variable, pFunctionType->params, iter)
			{
				const Variable* pVariable = iter.data();
				if(szParams != "")
					szParams += ", ";
				szParams += GetSignature(pVariable->type); // Do not supply the name of the parameter, since we don't care about it.
			}

			return szReturnType + " (" + szContainer + "::" + szVariableName + ")(" + szParams + ")";
		}
	}
	else if(pFunctionType->isConstructor())
	{
		std::string szContainer = GetSignature(pFunctionType->retType);
		std::string szParams = "";
		SFOREACH_OBJLIST(Variable, pFunctionType->params, iter)
		{
			const Variable* pVariable = iter.data();
			if(szParams != "")
				szParams += ", ";
			szParams += GetSignature(pVariable->type); // Do not supply the name of the parameter, since we don't care about it.
		}

		return "(" + szContainer + "::" + szVariableName + ")(" + szParams + ")";
	}
	else if(pFunctionType->isDestructor())
	{
		// This never seems to be true.
		cci_assert(false);
	}
	else // C-style function
	{
		std::string szReturnType = GetSignature(pFunctionType->retType);
		std::string szParams = "";
		SFOREACH_OBJLIST(Variable, pFunctionType->params, iter)
		{
			const Variable* pVariable = iter.data();
			if(szParams != "")
				szParams += ", ";
			szParams += GetSignature(pVariable->type); // Do not supply the name of the parameter, since we don't care about it.
		}
		
		if(szContainer != "")
			szContainer += "::";

		return szReturnType + " (" + szContainer + szVariableName + ")(" + szParams + ")";
	}
	
	cci_assert(false);
	return "UnknownFunctionType";
}

std::string CCIE_FunctionSignature::GetSignature(PointerType* pPointerType)
{
	cci_assert(pPointerType != NULL);
	cci_assert(pPointerType->atType != NULL);
	
	// If this is a pointer to a function, then the name of the function is the
	// pointer-asterisk. Otherwise, the pointer-asterisk comes after the type.
	if(pPointerType->atType->isFunctionType())
	{
		return GetSignature(pPointerType->atType, "*");
	}
	else
	{
		return GetSignature(pPointerType->atType) + "*";
	}
}

std::string CCIE_FunctionSignature::GetSignature(ReferenceType* pReferenceType)
{
	cci_assert(pReferenceType != NULL);
	cci_assert(pReferenceType->atType != NULL);

	// If this is a reference to a function, then the name of the function is
	// the reference-ampersand. Otherwise, the reference-ampersand comes after
	// the type.
	if(pReferenceType->atType->isFunctionType())
	{
		return GetSignature(pReferenceType->atType, "&");
	}
	else
	{
		return GetSignature(pReferenceType->atType) + "&";
	}
}

std::string CCIE_FunctionSignature::GetSignature(PointerToMemberType* pPointerToMemberType)
{
	cci_assert(pPointerToMemberType);
	cci_assert(pPointerToMemberType->atType != NULL);
	
	// If this is a pointer to a function, then the name of the function is the
	// pointer-asterisk.
	// If this is a pointer to a member, then the signature consists of the name
	// of the data type, followed by the container it is in, followed by the
	// pointer-asterisk.
	if(pPointerToMemberType->atType->isFunctionType())
	{
		return GetSignature(pPointerToMemberType->atType, "*");
	}
	else
	{
		return GetSignature(pPointerToMemberType->atType) + " " + GetSignature(pPointerToMemberType->inClassNAT) + "::*";
	}
}

std::string CCIE_FunctionSignature::GetSignature(CVAtomicType* pCVAtomicType)
{
	cci_assert(pCVAtomicType != NULL);
	return GetSignature(pCVAtomicType->atomic);
}

std::string CCIE_FunctionSignature::GetSignature(AtomicType* pAtomicType)
{
	cci_assert(pAtomicType != NULL);

	if(pAtomicType->isSimpleType())
	{
		return GetSignature(pAtomicType->asSimpleType());
	}
	else if(pAtomicType->isCompoundType())
	{
		return GetSignature(pAtomicType->asCompoundType());
	}
	else if(pAtomicType->isEnumType())
	{
		return GetSignature(pAtomicType->asEnumType());
	}
	
	cci_assert(false);
	return "UnknownAtomicType";
}

std::string CCIE_FunctionSignature::GetSignature(SimpleType* pSimpleType)
{
	cci_assert(pSimpleType != NULL);
	return simpleTypeName(pSimpleType->type);
}

std::string CCIE_FunctionSignature::GetSignature(CompoundType* pCompoundType)
{
	cci_assert(pCompoundType != NULL);
	/*
		return pCompoundType->fullyQualifiedName().c_str();
	/*/
		return GetScopeName(pCompoundType);
	/**/
}

std::string CCIE_FunctionSignature::GetSignature(EnumType* pEnumType)
{
	cci_assert(pEnumType != NULL);
	return std::string("enum ") + pEnumType->name;
}


// ----------------------------------------------------------------------------
// Helpers
// ----------------------------------------------------------------------------
std::string CCIE_FunctionSignature::ToString(CVFlags flags)
{
	std::string szFlags = toString(flags).c_str();
	if(szFlags != "")
		szFlags += " ";	

	return szFlags;
}

std::string CCIE_FunctionSignature::GetScopeName(Scope* pScope)
{
	if(pScope == NULL)
		return "";

	//
	// The implementation of this function is a copy of
	// 'string Scope::fullyQualifiedName()' (from cc_scope.cc), with the only
	// difference being that this function doesn't assert when the oldest
	// ancestor of pScope does not end in the global scope.
	//

	if(pScope->isGlobalScope())
		return "";

	std::stringstream ss;
	
	// Retrieve and prepend the name of the parent scope.
	if(pScope->parentScope != NULL && !pScope->parentScope->isGlobalScope())
	{
		ss << GetScopeName(pScope->parentScope);
		ss << "::";     // put this only *between* names, so none at start
	}

	// Retrieve the variable that names this scope and, subsequently, the name
	// of this scope.
	cci_assert(pScope->hasName());
	Variable* pVariable = pScope->getTypedefName();
	cci_assert(pVariable != NULL);

	if(pVariable->name != NULL)
    	ss << pVariable->name;
	else
		ss << "anonymous@" << toString(pVariable->loc);    // anonymous namespaces

	// If templates are involved, more needs to be done.
	TemplateInfo* tinfo = pScope->curCompound == NULL ? NULL : pScope->curCompound->templateInfo();
	if(tinfo != NULL)
	{
		if (tinfo->isPrimary())
		{
			if (tinfo->params.isEmpty())
			{
				// it has template info because it is contained inside a
				// template, but this class is not itself a template, so do not
				// print template arguments as if it were
			}
			else
			{
				// print the params like arguments for a primary
				ss << tinfo->paramsLikeArgsToString();
			}
		}
		else
		{
			if (tinfo->isInstantiation())
			{
				if (tinfo->instantiationOf->templateInfo()->isPartialSpec())
				{
					// print the partial spec args first, so then the instantiation
					// args can be interpreted relative to the partial spec args
					ss << sargsToString(tinfo->instantiationOf->templateInfo()->arguments);
				}
				else
				{
					// Kind of a disaster here.  'tinfo->arguments' includes arguments
					// applied to the templates that enclose this template.  So we
					// need to just look at the last 'n' arguments where 'n' is the
					// number of parameters of the template this was actually
					// instantiated from.
					//
					// TODO: The arguments need to be split into two lists.

					// How many arguments should we be printing?
					int n = tinfo->instantiationOf->templateInfo()->params.count();
					if (n == 0)
					{
						// This isn't even itself a template.
					}
					else
					{
						// How many arguments do we need to skip?
						int skip = tinfo->arguments.count() - n;
						xassert(skip >= 0);

						// set up iterator for skipping
						SObjList<STemplateArgument> const &slist = objToSObjListC(tinfo->arguments);
						SObjListIter<STemplateArgument> iter(slist);

						// skip
						while(skip--)
						{
							iter.adv();
						}

						// finally, print
						ss << sargsToString(iter);
					}
				}
			}
			else
			{
				ss << sargsToString(tinfo->arguments);
			}
		}
	}

	return ss.str();
}
