/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_FUNCTION_SIGNATURE_H
#define CCIE_FUNCTION_SIGNATURE_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"


// ----------------------------------------------------------------------------
// Class CCIE_FunctionSignature
// ----------------------------------------------------------------------------
/*
class CCIE_FunctionSignature
{
public:
	static std::string GetSignature(Function* pFunction);
	static std::string GetSignature(Variable* pVariable);

	static std::string GetCallSignature(Function* pFunction);
	static std::string GetCallSignature(Variable* pVariable);
	static std::string GetCallSignature(Type* pType);

private:
	static std::string GetFullyQualifiedName(Variable* pVariable);
	static std::string GetClassSignature(FunctionType* pFunctionType);
	static std::string GetCallSignatureWithClassName(Type* pType, std::string className);

	static std::string GetNameWithoutConversionOperator(Variable* pVariable);
	static std::string StripContainer(std::string signature);
};
*/

class CCIE_FunctionSignature
{
public:
	static std::string GetSignature(Function* pFunction);
	static std::string GetSignature(Variable* pVariable);

	static std::string GetCallSignature(Function* pFunction);
	static std::string GetCallSignature(Variable* pVariable);
	static std::string GetCallSignature(Type* pType);

private:
	static std::string GetSignature(Type* pType, std::string szVariableName = "", std::string szContainer = "");
	static std::string GetSignature(FunctionType* pFunctionType, std::string szVariableName, std::string szContainer);
	static std::string GetSignature(PointerType* pPointerType);
	static std::string GetSignature(ReferenceType* pReferenceType);
	static std::string GetSignature(PointerToMemberType* pPointerToMemberType);
	static std::string GetSignature(CVAtomicType* pCVAtomicType);
	static std::string GetSignature(AtomicType* pAtomicType);
	static std::string GetSignature(SimpleType* pSimpleType);
	static std::string GetSignature(CompoundType* pCompoundType);
	static std::string GetSignature(EnumType* pEnumType);

	// Helpers
	static std::string ToString(CVFlags flags);
	static std::string GetScopeName(Scope* pScope);
	
	friend class CCIE_LocalFunctionFactory;
};


#endif
