/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_LINKAGE_SEMANTICS_H
#define CCIE_LINKAGE_SEMANTICS_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_translation_unit_info.h"


// ----------------------------------------------------------------------------
// Class CCIE_LinkageSemantics
// ----------------------------------------------------------------------------
class CCIE_LinkageSemantics
{
	// ------------------------------------------------------------------------
	// Static accessor for convenience
	// ------------------------------------------------------------------------
public:
	static void MangleStaticLinkageSignatures(/*CCIE_TranslationUnitInfo & tuInfo*/);


	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
private:
	CCIE_LinkageSemantics(/*CCIE_TranslationUnitInfo & tuInfo*/);


	// ------------------------------------------------------------------------
	// Mangling
	// ------------------------------------------------------------------------
private:
	void _MangleStaticLinkageSignatures();
	void MangleFunctionCallSignatures();
	void MangleFunctionCall(CCI_FunctionCall* pFunctionCall);
	void MangleVirtualOverriddenSignatures();
	void MangleLocalFunctionSignatures();
	void MangleVirtualSignatureMapping();
	void MangleCallSignatureMapping();

	bool IsStaticLinkage(std::string szSignature);
	std::string GetMangledSignature(std::string szSignature);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	//CCIE_TranslationUnitInfo & m_tuInfo;
};


#endif
