/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_LOCAL_FUNCTION_FACTORY_H
#define CCIE_LOCAL_FUNCTION_FACTORY_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"
#include "ccie_function_declaration_factory.h"
#include "ccie_function_definition_factory.h"
#include "ccie_function_signature.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Class CCIE_LocalFunctionFactory
// ----------------------------------------------------------------------------
class CCIE_LocalFunctionFactory
{
	// ------------------------------------------------------------------------
	// Creation
	// ------------------------------------------------------------------------
public:
	static CCI_LocalFunction* Create(Function* pFunction)
	{
		// Validate the parameter.
		cci_assert(pFunction != NULL);
		cci_assert(pFunction->nameAndParams != NULL);

		// Gather some information on the new CCI_LocalFunction.
		Variable* pVariable     = pFunction->nameAndParams->var;
		/*
		bool bIsStaticLinkage   = pVariable->isStaticLinkage();
		bool bIsMethod          = pVariable->isMember();
		bool bIsVirtual         = (pVariable->flags & DF_VIRTUAL) == DF_VIRTUAL;
		*/
		std::string szClassName = pVariable->isMember() ? CCIE_FunctionSignature::GetScopeName(pVariable->scope) : "";

		/*
		Variable* pVariable     = pFunction->nameAndParams->var;
		bool bIsStaticLinkage   = pVariable->isStaticLinkage();
		bool bIsMethod          = pVariable->type->asFunctionType()->isMethod();
		bool bIsVirtual         = (pVariable->flags & DF_VIRTUAL) == DF_VIRTUAL;

		std::string szClassName;
		if(bIsMethod)
		{
			//szClassName = CCIE_FunctionSignature::GetScopeName(pVariable->type->asFunctionType()->getClassOfMember());
			szClassName = CCIE_FunctionSignature::GetScopeName(pVariable->scope);
		}
		else if(pVariable->isStaticMember())
		{
			szClassName = CCIE_FunctionSignature::GetScopeName(pVariable->scope);
		}
		else if(pVariable->type->asFunctionType()->isConstructor())
		{
			szClassName = CCIE_FunctionSignature::GetScopeName(pVariable->type->asFunctionType()->retType->asCompoundType());
		}
		else
		{
			szClassName = "";
		}
		*/
		

 		// Extract the signatures of the methods that this method overrides.
		StringVector overriddenMethodSignatures;
		if(pVariable->virtuallyOverride != NULL)
		{
			SObjSetIter<Variable*> it(*pVariable->virtuallyOverride);
			while(!it.isDone())
			{
				Variable* pOverriddenVariable = it.data();
				if(pOverriddenVariable != NULL)
				{
					overriddenMethodSignatures.push_back(CCIE_FunctionSignature::GetSignature(pOverriddenVariable));
				}
				it.adv();
			}
		}

		// Create and return a new CCI_LocalFunction.
		return new CCI_LocalFunction
		(
			pVariable->name,
		 	CCIE_FunctionSignature::GetSignature(pFunction),
			CCIE_FunctionSignature::GetCallSignature(pFunction),
			szClassName,
		 	CCIE_FunctionDeclarationFactory::Create(pVariable),
			CCIE_FunctionDefinitionFactory::Create(pFunction),
			GetLocalFunctionFlags(pVariable),
/*			bIsStaticLinkage,
			bIsMethod,
   			bIsVirtual,*/
	  		&overriddenMethodSignatures
		);
	}

	static CCI_LocalFunction* Create(Variable* pVariable)
	{
		// Validate the parameter.
		cci_assert(pVariable != NULL);

		// Gather some information on the new CCI_LocalFunction.
		/*bool bIsStaticLinkage   = pVariable->isStaticLinkage();
		bool bIsMethod          = pVariable->isMember();
		bool bIsVirtual         = (pVariable->flags & DF_VIRTUAL) == DF_VIRTUAL;*/
		std::string szClassName = pVariable->isMember() ? CCIE_FunctionSignature::GetScopeName(pVariable->scope) : "";

		/*
		bool bIsStaticLinkage   = pVariable->isStaticLinkage();
		bool bIsMethod          = pVariable->type->asFunctionType()->isMethod();
		bool bIsVirtual         = (pVariable->flags & DF_VIRTUAL) == DF_VIRTUAL;

		std::string szClassName;
		if(bIsMethod)
		{
			szClassName = CCIE_FunctionSignature::GetScopeName(pVariable->type->asFunctionType()->getClassOfMember());
		}
		else if(pVariable->type->asFunctionType()->isConstructor())
		{
			szClassName = CCIE_FunctionSignature::GetScopeName(pVariable->type->asFunctionType()->retType->asCompoundType());
		}
		else
		{
			szClassName = "";
		}
		*/

 		// Extract the signatures of the methods that this method overrides.
		StringVector overriddenMethodSignatures;
		if(pVariable->virtuallyOverride != NULL)
		{
			SObjSetIter<Variable*> it(*pVariable->virtuallyOverride);
			while(!it.isDone())
			{
				Variable* pOverriddenVariable = it.data();
				if(pOverriddenVariable != NULL)
				{
					overriddenMethodSignatures.push_back(CCIE_FunctionSignature::GetSignature(pOverriddenVariable));
				}
				it.adv();
			}
		}

		// Create and return a new CCI_LocalFunction.
		return new CCI_LocalFunction
		(
			pVariable->name,
			CCIE_FunctionSignature::GetSignature(pVariable),
			CCIE_FunctionSignature::GetCallSignature(pVariable),
			szClassName,
			CCIE_FunctionDeclarationFactory::Create(pVariable),
			NULL,
			GetLocalFunctionFlags(pVariable),
   			/*bIsStaticLinkage,
			bIsMethod,
   			bIsVirtual,*/
	  		&overriddenMethodSignatures
		);
	}
	
private:

	static int GetLocalFunctionFlags(Variable* pVariable)
	{
		cci_assert(pVariable != NULL);

		int iFlags = CCI_LFF_NONE;
		
		if(pVariable->isStaticLinkage()) iFlags |= CCI_LFF_STATIC_LINKAGE;

		if(pVariable->isMember())
		{
			// Flag this function as a method.
			iFlags |= CCI_LFF_METHOD;
			// Flag this method as virtual, if it is.
			if(pVariable->hasFlag(DF_VIRTUAL)) iFlags |= CCI_LFF_VIRTUAL;
			if(pVariable->hasFlag(DF_STATIC )) iFlags |= CCI_LFF_STATIC ;

			// If this method is implicitly defined, that is, defined by the
			// compiler, then it is always a pulic method. Otherwise, check
			// the variable's access flag to determine the access specifier.
			if(pVariable->isImplicitMemberFunc())
			{
				iFlags |= CCI_LFF_PUBLIC;
			}
			else
			{
				switch(pVariable->getAccess())
				{
				case AK_PUBLIC   : iFlags |= CCI_LFF_PUBLIC   ; break;
				case AK_PROTECTED: iFlags |= CCI_LFF_PROTECTED; break;
				case AK_PRIVATE  : iFlags |= CCI_LFF_PRIVATE  ; break;
				default: break;
				}
			}
		}

		// Flag this function as inline, if it is.
		if(pVariable->hasFlag(DF_INLINE)) iFlags |= CCI_LFF_INLINE;

		return iFlags;
	}
};


#endif

