/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_LOCAL_FUNCTION_REPOSITORY_H
#define CCIE_LOCAL_FUNCTION_REPOSITORY_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"
//#include "ci_local_function.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// class CCIE_LocalFunctionRepository
// ----------------------------------------------------------------------------
class CCIE_LocalFunctionRepository
{
	// ------------------------------------------------------------------------
	// Construction & destruction
	// ------------------------------------------------------------------------
public:
	CCIE_LocalFunctionRepository();
	~CCIE_LocalFunctionRepository();


	// ------------------------------------------------------------------------
	// Repository management
	// ------------------------------------------------------------------------
public:
	bool ContainsFunction(std::string signature);
	bool ContainsFunction(Function* pFunction);

	CCI_LocalFunction* GetFunction(std::string signature);
	LocalFunctionMap* GetFunctions();

	void AddFunction(Function* pFunction);
	void AddFunction(Variable* pVariable);

	void DeleteFunction(std::string signature);


	// ------------------------------------------------------------------------
	// Debugging
	// ------------------------------------------------------------------------
public:
	void Print(std::string prefix);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	LocalFunctionMap m_functions;
};


#endif
