/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ccie.h"
#include "ccie_cmd.h"
#include "ccie_verbose_printing.h"
#include "oink_global.h"
#include "oink.gr.gen.h"        // CCParse_Oink
#include "trace.h"
#include "oink_util.h"


int main(int argc, char **argv)
{
	traceAddSys("permissive");
	traceAddFromEnvVar();

	tFac = new TypeFactory_O;
	vFac = new ValueFactory;
	astPrinter = new ASTPrinter_O;

	CCIE_Cmd ccieCmd;
	oinkCmd = &ccieCmd;

	ExitCode code = NORMAL_ExitCode;
	CCIE m;
	m.typePrinter = &typePrinterOink;

	try
	{
		VERBOSE_PRINT("Initializing.");
		m.init_stage(argc, argv);
		CCParse_Oink ccParse(globalStrTable, globalLang);
		m.parseUserActions = &ccParse;
		m.parseEnv = &ccParse;

		VERBOSE_PRINT("Parsing.");
		m.parse_stage();
		VERBOSE_PRINT("Typechecking.");
		m.typecheck_stage();
		VERBOSE_PRINT("Elaboration.");
		m.elaborate_stage();
		m.markRealVars_stage();
		m.filter_stage();
		m.prettyPrint_stage();

		VERBOSE_PRINT("Extracting.");
		m.extract_stage();
	}
	catch (xBase &e)
	{
		std::cerr << e << std::endl;
		code = INTERNALERROR_ExitCode;
		if(UserError *ue = dynamic_cast<UserError*>(&e))
			code = ue->exitCode;
	}

	return code;
}
