/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_SOURCELOC_FACTORY_H
#define CCIE_SOURCELOC_FACTORY_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"
#include <libcci/cci.h>
#include "ccie_translation_unit_info.h"


// ----------------------------------------------------------------------------
// Class CCIE_SourceLocFactory
// ----------------------------------------------------------------------------
class CCIE_SourceLocFactory
{
	// ------------------------------------------------------------------------
	// Creation
	// ------------------------------------------------------------------------
public:
	static CCI_SourceLoc* Create(SourceLoc sourceLoc)
	{
		return new CCI_SourceLoc
		(
			sourceLocManager->getFile(sourceLoc),
			sourceLocManager->getLine(sourceLoc),
			sourceLocManager->getCol(sourceLoc),
			CCIE_TranslationUnitInfo::m_szSourceFileName
		);
	}

	static CCI_SourceLoc* Create(Variable* pVariable)
	{
		cci_assert(pVariable != NULL);
		return Create(pVariable->loc);
	}

	static CCI_SourceLoc* Create(Function* pFunction)
	{
		cci_assert(pFunction != NULL);
		return Create(pFunction->getLoc());
	}
};


#endif
