/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_static_call_visitor.h"
#include "ccie_function_call_factory.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Construction
// ----------------------------------------------------------------------------
CCIE_StaticCallVisitor::CCIE_StaticCallVisitor(/*CCIE_TranslationUnitInfo & tuInfo*/) :
	m_loweredVisitor(this)/*,
	m_tuInfo(tuInfo)*/
{
}


// ----------------------------------------------------------------------------
// Traversal
// ----------------------------------------------------------------------------
void CCIE_StaticCallVisitor::Traverse()
{
	cci_assert(CCIE_TranslationUnitInfo::m_pTranslationUnit != NULL);
	CCIE_TranslationUnitInfo::m_pTranslationUnit->traverse(m_loweredVisitor);
}


// ----------------------------------------------------------------------------
// ASTVisitor implementation
// ----------------------------------------------------------------------------
#include "ccie_call_visitor.h"
bool CCIE_StaticCallVisitor::visitTopForm(TopForm* pTopForm)
{
	cci_assert(pTopForm != NULL);

	if(pTopForm->isTF_decl())
	{
		TF_decl* pTF_decl = pTopForm->asTF_decl();

		Declaration* pDeclaration = pTF_decl->decl;
		cci_assert(pDeclaration != NULL);

		// Iterate over the list of declarators and handle each element.
		FAKELIST_FOREACH(Declarator, pDeclaration->decllist, pDeclarator)
		{
			Initializer* pInitializer = pDeclarator->init;
			if(pInitializer != NULL)
			{
				// Collect the first (and possible only) part of the static
				// initialization calls.
				CCIE_CallVisitor callVisitor(&CCIE_TranslationUnitInfo::m_initializingCalls);
				callVisitor.Traverse(pInitializer);

				// If this is the declaration of an object (which has a
				// ctor and a dtor), rather than the declaration of a
				// language primitive (like int), we need to look in the
				// ctor and dtor statements for function calls.
				if(pInitializer->isIN_ctor())
				{
					Statement* pCtorStatement = pDeclarator->ctorStatement;
					Statement* pDtorStatement = pDeclarator->dtorStatement;
					cci_assert(pCtorStatement != NULL);
					cci_assert(pDtorStatement != NULL);

					if(pCtorStatement->isS_expr())
					{
						CCIE_CallVisitor callVisitor(&CCIE_TranslationUnitInfo::m_initializingCalls);
						callVisitor.Traverse(pCtorStatement);
					}

					if(pDtorStatement->isS_expr())
					{
						CCIE_CallVisitor callVisitor(&CCIE_TranslationUnitInfo::m_finalizingCalls);
						callVisitor.Traverse(pDtorStatement);
					}
				}
			}
		}
	}
	
	return true;
}
