/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_STATIC_CALL_VISITOR_H
#define CCIE_STATIC_CALL_VISITOR_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "cc_ast.h"
#include "cc_ast_aux.h"
#include "ccie_translation_unit_info.h"
//#include "ci_typedefs.h"
#include <libcci/cci.h>
#include <vector>


// ----------------------------------------------------------------------------
// Class CCIE_StaticCallVisitor
// ----------------------------------------------------------------------------
class CCIE_StaticCallVisitor : public ASTVisitor
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	CCIE_StaticCallVisitor(/*CCIE_TranslationUnitInfo & tuInfo*/);

	
	// ------------------------------------------------------------------------
	// Traversal
	// ------------------------------------------------------------------------
public:
	void Traverse();


	// ------------------------------------------------------------------------
	// ASTVisitor implementation
	// ------------------------------------------------------------------------
private:
	virtual bool visitTopForm(TopForm* pTopForm);

private:
	void AddInitializingCall(Variable* pVariable);
	void AddFinalizingCall(Variable* pVariable);


	// ------------------------------------------------------------------------
	// Attributes
	// ------------------------------------------------------------------------
private:
	// The LoweredASTVisitor to be used for traversals.
	LoweredASTVisitor m_loweredVisitor;

	//
	//CCIE_TranslationUnitInfo & m_tuInfo;
};


#endif
