/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_translation_unit_info.h"
#include <libcci/cci.h>


// ----------------------------------------------------------------------------
// Static initialization
// ----------------------------------------------------------------------------
std::string                  CCIE_TranslationUnitInfo::m_szSourceFileName = "";
TranslationUnit*             CCIE_TranslationUnitInfo::m_pTranslationUnit = NULL;
CCIE_LocalFunctionRepository CCIE_TranslationUnitInfo::m_localFunctionRepository;
//CCI_CallCandidates           CCIE_TranslationUnitInfo::m_callCandidates(CCIE_TranslationUnitInfo::m_localFunctionRepository.GetFunctions());
CCI_CallCandidates           CCIE_TranslationUnitInfo::m_callCandidates;
FunctionCallVector           CCIE_TranslationUnitInfo::m_initializingCalls;
FunctionCallVector           CCIE_TranslationUnitInfo::m_finalizingCalls;


// ----------------------------------------------------------------------------
// Construction
// ----------------------------------------------------------------------------
/*
CCIE_TranslationUnitInfo::CCIE_TranslationUnitInfo() :
	m_callCandidates(m_localFunctionRepository.GetFunctions())
{

}
*/


// ----------------------------------------------------------------------------
// Debugging
// ----------------------------------------------------------------------------
void CCIE_TranslationUnitInfo::Print(std::string prefix)
{
	std::cout << prefix << "CallInfo (" << m_szSourceFileName << ")" << std::endl;
	std::cout << prefix << "{" << std::endl;
	PrintLocalFunctions   (prefix + "\t");
	PrintInitializingCalls(prefix + "\t");
	PrintFinalizingCalls  (prefix + "\t");
	m_callCandidates.PrintOut(prefix + "\t");
	std::cout << prefix << "}" << std::endl;
}

void CCIE_TranslationUnitInfo::PrintLocalFunctions(std::string prefix)
{
	std::cout << prefix << "Local functions" << std::endl;
	std::cout << prefix << "{" << std::endl;

	LocalFunctionMap* pLocalFunctions = m_localFunctionRepository.GetFunctions();
	LocalFunctionMap::iterator itLocalFunction = pLocalFunctions->begin();
	while(itLocalFunction != pLocalFunctions->end())
	{
		itLocalFunction->second->PrintOut(prefix + "\t");
		itLocalFunction++;
	}

	std::cout << std::endl << prefix << "}" << std::endl;
}

void CCIE_TranslationUnitInfo::PrintInitializingCalls(std::string prefix)
{
	std::cout << prefix << "Initializing calls" << std::endl;
	std::cout << prefix << "{" << std::endl;

	FunctionCallVector::iterator it = m_initializingCalls.begin();
	while(it != m_initializingCalls.end())
	{
		(*it)->PrintOut(prefix + "\t");
		it++;
	}
	std::cout << std::endl << prefix << "}" << std::endl;
}

void CCIE_TranslationUnitInfo::PrintFinalizingCalls(std::string prefix)
{
	std::cout << prefix << "Finalizing calls" << std::endl;
	std::cout << prefix << "{" << std::endl;

	FunctionCallVector::iterator it = m_finalizingCalls.begin();
	while(it != m_finalizingCalls.end())
	{
		(*it)->PrintOut(prefix + "\t");
		it++;
	}
	std::cout << std::endl << prefix << "}" << std::endl;
}
