/***************************************************************************
 *   Copyright (C) 2009 by Hessel Hoogendorp                               *
 *   bugs.ccc@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CCIE_TRANSLATION_UNIT_INFO_H
#define CCIE_TRANSLATION_UNIT_INFO_H


// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------
#include "ccie_local_function_repository.h"


// ----------------------------------------------------------------------------
// Typedefs
// ----------------------------------------------------------------------------
//typedef std::map<std::string, StringVector*> StringVectorMap;


// ----------------------------------------------------------------------------
// Class CCIE_TranslationUnitInfo
// ----------------------------------------------------------------------------
class CCIE_TranslationUnitInfo
{
	// ------------------------------------------------------------------------
	// Construction
	// ------------------------------------------------------------------------
public:
	//CCIE_TranslationUnitInfo();
	//~CCIE_TranslationUnitInfo();


	// ------------------------------------------------------------------------
	// Public attributes
	// ------------------------------------------------------------------------
public:
	static std::string                  m_szSourceFileName;
	static TranslationUnit*             m_pTranslationUnit;
	static CCIE_LocalFunctionRepository m_localFunctionRepository;
	static FunctionCallVector           m_initializingCalls;
	static FunctionCallVector           m_finalizingCalls;

	static CCI_CallCandidates           m_callCandidates;


	// ------------------------------------------------------------------------
	// Debugging
	// ------------------------------------------------------------------------
public:
	static void Print(std::string prefix);

private:
	static void PrintLocalFunctions(std::string prefix);
	static void PrintInitializingCalls(std::string prefix);
	static void PrintFinalizingCalls(std::string prefix);
};


#endif
