eval(read_file("dehydra_scripts/query_inheritance.js"))

function list_unimplemented_interfaces(klass, ls) {
  var cls = klass.getChildren()
  for(var i = 0;i < cls.length;i++) {
    var c = cls[i]
    // found a concrete implementation of klass
    if (!c.isPureVirtual())
      return
    // c is also purevirtual..so append it's children
    c.getChildren(cls)
  }
  // if we got here all children are also virtual
  cls.push(klass)
  ls.push.apply(ls, cls);
}

function input_end() {
  var nsISupports = getCachedClass("nsISupports")
  var ls = nsISupports.getChildren()
  print(ls.length + " classes derived from nsISupports")
  ls = ls.filter(function (x) {return !x.isXPIDL() && x.isPureVirtual()})
  print(ls.length + " non-XPIDL interfaces")
  //filter out functions that have more than 1 child
  empty_interfaces = []
  ls = ls.filter(function (x) {
    var ls = x.getChildren()
    if (ls.length == 1) {
      return ls[0].getChildren().length == 0
    }
    list_unimplemented_interfaces(x, empty_interfaces)
    return false
  })
  
  print("Only one implementation: " + ls.length)
  print("No Implementation: " + empty_interfaces.length)
  print(empty_interfaces.map(function (x) {return x.getLoc() + ": "+x.name}).join("\n"))
}
