const jsval = "wchar_t"
const UNROOTED = 0
const MUST_UNROOT = UNROOTED + 1
const JSVAL = MUST_UNROOT + 1
const register = "registerGC"
const unregister = "unregisterGC"

function uno_check() {
  if(select("", [TYPE(jsval), DECL])) {
    mark(JSVAL)
  }
  if(refine("", [TYPE(jsval)], [DEF])) {
    mark(UNROOTED)
  } else if(select("", [PARAM_OF(register)])) {
    if(match(UNROOTED)) {
      unmark(UNROOTED)
      mark(MUST_UNROOT)
    } else {
      error("ReRegistering a rooted jsval");
    }
  } else if(select("", [PARAM_OF(unregister)])) {
    if(match(MUST_UNROOT))
      unmark(MUST_UNROOT)
    else {
      list()
      error("Unregistering an unrooted value")
    }
  } else if(select("",[FCALL])) {
      if(select("", [USE]))
        if(match(UNROOTED)) {
          list()
          error("Passing unrooted values as params")
        }
  } else if(select("", [ALIAS])) {
    list()
    if(marked(JSVAL))
      error("Not allowed to alias jsvals")
  }
}

function path_end(state) {
  if(marked(MUST_UNROOT))
    error("jsvals left unrooted");
}